/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jsfunit.richfaces;

import com.meterware.httpunit.PostMethodWebRequest;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.context.FacesContext;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.ajax4jsf.framework.renderer.AjaxRendererUtils;
import org.jboss.jsfunit.facade.ClientIDs;
import org.jboss.jsfunit.facade.JSFClientSession;
import org.jboss.jsfunit.facade.WebRequestFactory;
import org.jboss.jsfunit.richfaces.JSFAJAX;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ajax4jsfClient {
    protected JSFClientSession client;
    protected WebRequestFactory requestFactory;
    protected String ajaxResponse;

    public Ajax4jsfClient(JSFClientSession client) {
        if (client == null) {
            throw new NullPointerException("client can not be null");
        }
        this.client = client;
        this.requestFactory = new WebRequestFactory(client);
    }

    private String makeClientID(String[] terms, int treeDepth) {
        StringBuilder builder = new StringBuilder(terms[0]);
        for (int i = 1; i < treeDepth; ++i) {
            builder.append(':');
            builder.append(terms[i]);
        }
        return builder.toString();
    }

    protected Map<UIData, Integer> setRowIndicies(String componentID) throws SAXException, IOException {
        ClientIDs clientIDs = this.client.getClientIDs();
        String clientID = clientIDs.findClientID(componentID);
        HashMap<UIData, Integer> rowIndices = new HashMap<UIData, Integer>();
        String[] terms = clientID.split(Character.toString(':'));
        for (int i = 0; i < terms.length; ++i) {
            try {
                int rowIndex = Integer.parseInt(terms[i]);
                UIComponent parent = clientIDs.findComponent(this.makeClientID(terms, i));
                if (!(parent instanceof UIData)) continue;
                UIData uiData = (UIData)parent;
                rowIndices.put(uiData, new Integer(uiData.getRowIndex()));
                uiData.setRowIndex(rowIndex);
                continue;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return rowIndices;
    }

    protected void restoreRowIndices(Map<UIData, Integer> rowIndices) {
        for (UIData uiData : rowIndices.keySet()) {
            uiData.setRowIndex(rowIndices.get(uiData).intValue());
        }
    }

    public String getAjaxResponse() {
        return this.ajaxResponse;
    }

    public void ajaxSubmit(String componentID) throws SAXException, IOException {
        this.ajaxSubmit(componentID, new HashMap<String, String>());
    }

    public void ajaxSubmit(String componentID, Map<String, String> userParams) throws SAXException, IOException {
        ClientIDs clientIDs = this.client.getClientIDs();
        Map<UIData, Integer> indiciesToRestore = this.setRowIndicies(componentID);
        UIComponent uiComp = clientIDs.findComponent(componentID);
        Map options = this.buildEventOptions(uiComp);
        PostMethodWebRequest req = this.requestFactory.buildRequest((String)options.get("actionUrl"), componentID);
        this.setA4JParam(req, uiComp);
        this.addExtraA4JParams(req, options);
        this.restoreRowIndices(indiciesToRestore);
        this.addExtraUserParams(req, userParams);
        this.doAjaxRequest(req, options);
    }

    protected void doAjaxRequest(PostMethodWebRequest req, Map options) throws SAXException, IOException {
        Document oldDoc = this.client.getUpdatedDOM();
        this.client.doWebRequest((WebRequest)req);
        WebResponse newResponse = this.client.getWebResponse();
        this.ajaxResponse = this.client.getWebResponse().getText();
        try {
            WebRequest refreshRequest = JSFAJAX.processResponse(oldDoc, newResponse, options);
            if (refreshRequest != null) {
                this.client.doWebRequest(refreshRequest);
            }
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
    }

    protected void addExtraA4JParams(PostMethodWebRequest req, Map options) {
        Map params = (Map)options.get("parameters");
        for (String param : params.keySet()) {
            Object value = params.get(param);
            if (value != null) {
                req.setParameter(param, value.toString());
                continue;
            }
            req.setParameter(param, (String)null);
        }
    }

    protected void addExtraUserParams(PostMethodWebRequest req, Map<String, String> params) {
        for (String name : params.keySet()) {
            String value = params.get(name);
            req.setParameter(name, value);
        }
    }

    Map buildEventOptions(UIComponent uiComp) {
        FacesContext ctx = FacesContext.getCurrentInstance();
        return AjaxRendererUtils.buildEventOptions((FacesContext)ctx, (UIComponent)uiComp);
    }

    void setA4JParam(PostMethodWebRequest req, UIComponent uiComp) {
        FacesContext ctx = FacesContext.getCurrentInstance();
        UIComponent container = (UIComponent)AjaxRendererUtils.findAjaxContainer((FacesContext)ctx, (UIComponent)uiComp);
        req.setParameter("AJAXREQUEST", container.getClientId(ctx));
    }
}

