/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jsfunit.richfaces;

import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.jboss.jsfunit.facade.DOMUtil;
import org.jboss.jsfunit.framework.JSFUnitFilter;
import org.jboss.jsfunit.framework.WebConversationFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class JSFAJAX {
    private JSFAJAX() {
    }

    private static WebRequest handleRedirect(String location) {
        HttpServletRequest req = (HttpServletRequest)JSFAJAX.extContext().getRequest();
        String urlPrefix = req.getScheme() + "://" + req.getServerName() + ":" + req.getServerPort();
        GetMethodWebRequest request = new GetMethodWebRequest(urlPrefix + location);
        request.setParameter("JSESSIONID", JSFAJAX.getSession().getId());
        return request;
    }

    static WebRequest processResponse(Document oldDoc, WebResponse newResponse, Map options, String contentType) throws SAXException, ParserConfigurationException, IOException, TransformerException {
        Element metaTag;
        String idsFromResponse;
        String ajaxResponse = newResponse.getHeaderField("Ajax-Response");
        String location = newResponse.getHeaderField("Location");
        if (!ajaxResponse.equals("true") && location != null) {
            return JSFAJAX.handleRedirect(location);
        }
        if (!ajaxResponse.equals("true")) {
            return null;
        }
        String[] idsToReplace = null;
        Set affected = (Set)options.get("affected");
        if (affected != null) {
            idsToReplace = affected.toArray(new String[0]);
        }
        if ((idsFromResponse = newResponse.getHeaderField("Ajax-Update-Ids")) != null) {
            idsToReplace = idsFromResponse.split(",");
        }
        if ((metaTag = DOMUtil.findElementWithAttribValue((String)"name", (String)"Ajax-Update-Ids", (Element)newResponse.getDOM().getDocumentElement())) != null) {
            idsToReplace = metaTag.getAttribute("content").split(",");
        }
        idsToReplace = JSFAJAX.removeEmptyElements(idsToReplace);
        return JSFAJAX.updatePage(oldDoc, DOMUtil.convertToDomLevel2((Document)newResponse.getDOM()), idsToReplace, contentType);
    }

    private static String[] removeEmptyElements(String[] elements) {
        ArrayList<String> nonEmpty = new ArrayList<String>();
        for (int i = 0; i < elements.length; ++i) {
            if (elements[i] == null || elements[i] == "") continue;
            nonEmpty.add(elements[i]);
        }
        return nonEmpty.toArray(new String[0]);
    }

    private static WebRequest updatePage(Document oldDoc, Document newDoc, String[] idsToReplace, String contentType) throws SAXException, ParserConfigurationException, IOException, TransformerException {
        for (int i = 0; i < idsToReplace.length; ++i) {
            Element oldElement = DOMUtil.findElementWithID((String)idsToReplace[i], (Document)oldDoc);
            if (oldElement == null) continue;
            Element newElement = DOMUtil.findElementWithID((String)idsToReplace[i], (Document)newDoc);
            Node parent = oldElement.getParentNode();
            Node importedNode = oldDoc.importNode(newElement, true);
            parent.replaceChild(importedNode, oldElement);
        }
        JSFAJAX.replaceAjaxViewState(oldDoc, newDoc);
        JSFAJAX.addResponseStringToSession(DOMUtil.docToHTMLString((Document)oldDoc));
        return JSFAJAX.createJSFUnitFilterRequest(contentType);
    }

    private static void replaceAjaxViewState(Document oldDoc, Document newDoc) {
        Element idsSpan = DOMUtil.findElementWithID((String)"ajax-view-state", (Document)newDoc);
        if (idsSpan == null) {
            idsSpan = DOMUtil.findElementWithID((String)"ajax-update-ids", (Document)newDoc);
        }
        if (idsSpan == null) {
            return;
        }
        NodeList inputs = oldDoc.getElementsByTagName("input");
        NodeList newInputs = idsSpan.getElementsByTagName("input");
        JSFAJAX.replaceViewState(inputs, newInputs);
        newInputs = idsSpan.getElementsByTagName("INPUT");
        JSFAJAX.replaceViewState(inputs, newInputs);
    }

    private static void replaceViewState(NodeList inputs, NodeList newInputs) {
        if (newInputs.getLength() == 0 || inputs.getLength() == 0) {
            return;
        }
        for (int i = 0; i < newInputs.getLength(); ++i) {
            Element newInput = (Element)newInputs.item(i);
            String newInputName = newInput.getAttribute("name");
            for (int j = 0; j < inputs.getLength(); ++j) {
                Element input = (Element)inputs.item(j);
                String inputName = input.getAttribute("name");
                if (!inputName.equals(newInputName)) continue;
                input.setAttribute("value", newInput.getAttribute("value"));
            }
        }
    }

    static void addResponseStringToSession(String responseString) {
        JSFAJAX.getSession().setAttribute(JSFUnitFilter.ALT_RESPONSE, (Object)responseString);
    }

    static WebRequest createJSFUnitFilterRequest(String contentType) throws MalformedURLException {
        String urlString = "/ServletRedirector";
        GetMethodWebRequest request = new GetMethodWebRequest(JSFAJAX.getWarURL() + urlString);
        request.setParameter("JSESSIONID", JSFAJAX.getSession().getId());
        if (contentType == null) {
            contentType = "text/html";
        }
        request.setHeaderField("Content-Type", contentType);
        return request;
    }

    private static ExternalContext extContext() {
        return FacesContext.getCurrentInstance().getExternalContext();
    }

    private static HttpSession getSession() {
        return (HttpSession)JSFAJAX.extContext().getSession(true);
    }

    private static String getWarURL() {
        Map appMap = JSFAJAX.extContext().getApplicationMap();
        return (String)appMap.get(WebConversationFactory.WAR_URL);
    }
}

