/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jsfunit.richfaces;

import com.meterware.httpunit.PostMethodWebRequest;
import com.meterware.httpunit.WebForm;
import com.meterware.httpunit.WebRequest;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.context.FacesContext;
import javax.xml.transform.TransformerException;
import org.ajax4jsf.renderkit.AjaxRendererUtils;
import org.jboss.jsfunit.facade.ClientIDs;
import org.jboss.jsfunit.facade.DOMUtil;
import org.jboss.jsfunit.facade.JSFClientSession;
import org.jboss.jsfunit.facade.WebRequestFactory;
import org.jboss.jsfunit.richfaces.Ajax4jsfClient;
import org.jboss.jsfunit.richfaces.JSFAJAX;
import org.jboss.jsfunit.richfaces.ScrollerControl;
import org.richfaces.component.UITab;
import org.richfaces.component.UITabPanel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class RichFacesClient
extends Ajax4jsfClient {
    public RichFacesClient(JSFClientSession client) {
        super(client);
    }

    Map buildEventOptions(UIComponent uiComp) {
        FacesContext ctx = FacesContext.getCurrentInstance();
        return AjaxRendererUtils.buildEventOptions((FacesContext)ctx, (UIComponent)uiComp);
    }

    void setA4JParam(PostMethodWebRequest req, UIComponent uiComp) {
        FacesContext ctx = FacesContext.getCurrentInstance();
        UIComponent container = (UIComponent)AjaxRendererUtils.findAjaxContainer((FacesContext)ctx, (UIComponent)uiComp);
        req.setParameter("AJAXREQUEST", container.getClientId(ctx));
    }

    public void setDataFilterSlider(String componentID, String value) throws SAXException {
        this.setSuffixxedValue(componentID, value, "slider_val");
    }

    public void setInputNumberSlider(String componentID, String value) throws SAXException, IOException {
        String clientID = this.client.getClientIDs().findClientID(componentID);
        Document doc = this.client.getUpdatedDOM();
        Element input = DOMUtil.findElementWithID((String)(clientID + "Input"), (Document)doc);
        if (input.getAttribute("type").equals("hidden")) {
            input.setAttribute("type", "text");
            this.refreshPageFromDOM();
        }
        this.client.setParameter(clientID, clientID + "Input", clientID, value);
    }

    public void setInputNumberSpinner(String componentID, String value) throws SAXException, IOException {
        String clientID = this.client.getClientIDs().findClientID(componentID);
        Element docElement = this.client.getUpdatedDOM().getDocumentElement();
        Element input = DOMUtil.findElementWithAttribValue((String)"name", (String)clientID, (Element)docElement);
        input.setAttribute("value", value);
        this.refreshPageFromDOM();
    }

    public void setCalendarValue(String componentID, String value) throws SAXException, IOException {
        Document doc;
        String clientID = this.client.getClientIDs().findClientID(componentID);
        Element input = DOMUtil.findElementWithID((String)(clientID = clientID + "InputDate"), (Document)(doc = this.client.getUpdatedDOM()));
        if (!input.getAttribute("readonly").equals("")) {
            input.removeAttribute("readonly");
            this.refreshPageFromDOM();
        }
        this.setSuffixxedValue(componentID, value, "InputDate");
    }

    private void refreshPageFromDOM() throws SAXException, IOException {
        Document doc = this.client.getUpdatedDOM();
        try {
            JSFAJAX.addResponseStringToSession(DOMUtil.docToHTMLString((Document)doc));
            this.client.doWebRequest(JSFAJAX.createJSFUnitFilterRequest(this.getContentType()));
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private void setSuffixxedValue(String componentID, String value, String suffix) throws SAXException {
        String clientID = this.client.getClientIDs().findClientID(componentID);
        String renderedInputID = clientID + suffix;
        this.client.setParameter(clientID, renderedInputID, renderedInputID, value);
    }

    public void clickDataTableScroller(String componentID, int value) throws SAXException, IOException {
        this.clickDataTableScroller(componentID, Integer.toString(value));
    }

    public void clickDataTableScroller(String componentID, ScrollerControl control) throws SAXException, IOException {
        this.clickDataTableScroller(componentID, control.toString());
    }

    private void clickDataTableScroller(String componentID, String control) throws SAXException, IOException {
        String clientID = this.client.getClientIDs().findClientID(componentID);
        HashMap<String, String> params = new HashMap<String, String>(1);
        params.put(clientID, control);
        this.ajaxSubmit(clientID, params);
    }

    public void clickPanelMenuItem(String componentID) throws SAXException, IOException {
        String clientID = this.client.getClientIDs().findClientID(componentID);
        String selectedItem = clientID;
        if (selectedItem.contains(":")) {
            selectedItem = clientID.substring(clientID.lastIndexOf(58) + 1, clientID.length());
        }
        HashMap<String, String> params = new HashMap<String, String>(2);
        String formID = this.client.getForm(componentID).getID();
        params.put("panelMenuActionform:" + selectedItem, formID + ":" + selectedItem);
        params.put(formID + ":ajaxPanelMenuselectedItemName", selectedItem);
        this.ajaxSubmit(clientID, params);
    }

    public void dragAndDrop(String dragComponentID, String dropTargetComponentID) throws SAXException, IOException {
        String dragClientID = this.client.getClientIDs().findClientID(dragComponentID);
        String dropClientID = this.client.getClientIDs().findClientID(dropTargetComponentID);
        HashMap<String, String> params = new HashMap<String, String>(3);
        params.put("dragSourceId", dragClientID);
        params.put("dropTargetId", dropClientID);
        params.put(dragClientID, dragClientID);
        this.ajaxSubmit(dropClientID, params);
    }

    public void clickTab(String tabPanelComponentID, String tabComponentID) throws SAXException, IOException {
        UITab tab = (UITab)this.client.getClientIDs().findComponent(tabComponentID);
        if (tab.isDisabled()) {
            return;
        }
        UITabPanel panel = (UITabPanel)this.client.getClientIDs().findComponent(tabPanelComponentID);
        String switchType = panel.getSwitchType();
        if (switchType.equals("server")) {
            this.clickServerTab(tabPanelComponentID, tabComponentID);
        }
        if (switchType.equals("ajax")) {
            this.clickAjaxTab(tabPanelComponentID, tabComponentID);
        }
    }

    private void clickAjaxTab(String tabPanelComponentID, String tabComponentID) throws SAXException, IOException {
        ClientIDs clientIDs = this.client.getClientIDs();
        Map<UIData, Integer> indiciesToRestore = this.setRowIndicies(tabComponentID);
        UIComponent uiComp = clientIDs.findComponent(tabComponentID);
        Map options = this.buildEventOptions(uiComp);
        WebForm form = this.findFormForTabPanel(tabPanelComponentID);
        PostMethodWebRequest req = this.requestFactory.buildRequest(form);
        this.setA4JParam(req, uiComp);
        this.addExtraA4JParams(req, options);
        this.restoreRowIndices(indiciesToRestore);
        this.doAjaxRequest(req, options);
    }

    private void clickServerTab(String tabPanelComponentID, String tabComponentID) throws SAXException, IOException {
        String panelClientID = this.client.getClientIDs().findClientID(tabPanelComponentID);
        String tabClientID = this.client.getClientIDs().findClientID(tabComponentID);
        WebForm form = this.findFormForTabPanel(tabPanelComponentID);
        String formID = form.getID();
        WebRequestFactory reqFactory = new WebRequestFactory(this.client);
        PostMethodWebRequest postRequest = reqFactory.buildRequest(form);
        postRequest.setParameter(formID + ":_idcl", tabClientID);
        postRequest.setParameter(tabClientID + "_server_submit", tabClientID + "_server_submit");
        this.client.doWebRequest((WebRequest)postRequest);
    }

    private WebForm findFormForTabPanel(String tabPanelComponentID) throws SAXException {
        String tabPanelClientID = this.client.getClientIDs().findClientID(tabPanelComponentID);
        WebForm form = this.client.getWebResponse().getFormWithID(tabPanelClientID + ":_form");
        if (form != null) {
            return form;
        }
        return this.client.getForm(tabPanelClientID);
    }
}

