package org.jboss.jsr299.tck.api;

import javax.context.Context;

import org.jboss.jsr299.tck.spi.Beans;
import org.jboss.jsr299.tck.spi.Containers;
import org.jboss.jsr299.tck.spi.Contexts;
import org.jboss.jsr299.tck.spi.EL;
import org.jboss.jsr299.tck.spi.Managers;
import org.jboss.jsr299.tck.spi.StandaloneContainers;

/**
 * The configuration of the TCK.
 * 
 * The TCK may be configured using system properties or placed in a properties 
 * file called META-INF/web-beans-tck.properties.
 * 
 * Porting package property names are the FQCN of the SPI class. Other property 
 * names (one for each non-porting package SPI configuration option) are 
 * specified here. The defaults are also listed here.
 * 
 * The TCK may also be configured programatically through this interface
 * 
 * @author Pete Muir
 *
 */
public interface Configuration
{
   
   public static final String OUTPUT_DIRECTORY_PROPERTY_NAME = "org.jboss.jsr299.tck.outputDirectory";
   public static final String STANDALONE_PROPERTY_NAME = "org.jboss.jsr299.tck.standalone";
   public static final String RUN_INTEGRATION_TESTS_PROPERTY_NAME = "org.jboss.jsr299.tck.runIntegrationTests";
   public static final String CONNECT_TIMEOUT_PROPERTY_NAME = "org.jboss.jsr299.tck.connectTimeout";
   public static final String LIBRARY_DIRECTORY_PROPERTY_NAME = "org.jboss.jsr299.tck.libraryDirectory";
   public static final String HOST_PROPERTY_NAME = "org.jboss.jsr299.tck.host";
   public static final String TEST_CLASS_PROPERTY_NAME = "org.jboss.jsr299.tck.testClass";
   
   public static final String DEFAULT_OUTPUT_DIRECTORY = System.getProperty("java.io.tmpdir") + "/jsr-299-tck/";
   public static final boolean DEFAULT_STANDALONE = true;
   public static final boolean DEFAULT_RUN_INTEGRATION_TESTS = false;
   public static final int DEFAULT_CONNECT_DELAY = 5000;
   public static final boolean DEFAULT_WRITE_DEPLOYED_ARCHIVES_TO_DISK = false;
   public static final String DEFAULT_LIBRARY_DIRECTORY = null;
   public static final String DEFAULT_HOST = "localhost:8080";
   public static final int DEFAULT_CONNECT_RETRIES = 2;
   
   /**
    * The output directory to put TCK specific output. The TestNG output 
    * directory is configured via TestNG.
    * 
    * By default set to ${tmp}/jsr-299-tck
    */
   public String getOutputDirectory();
   
   /**
    * Whether the TCK is in standalone mode or not.
    * 
    * By default true
    */
   public boolean isStandalone();
   
   /**
    * When the TCK is running in container tests it will attempt to connect to
    * the server every 200ms until the timeout is reached.
    * 
    * By default 5000ms
    */
   public int getConnectTimeout();
   
   /**
    * The TCK allows additional libraries to be put in the deployed test
    * artifacts (for example the porting package for the implementation). Any
    * jars in this directory will be added to the deployed artifact.
    * 
    * By default no directory is used.
    */
   public String getLibraryDirectory();
   
   /**
    * The TCK test launcher
    * 
    * @see TestLauncher
    * 
    */
   public TestLauncher getInContainerTestLauncher();
   
   /**
    * The implementation of {@link Beans} in use.
    */
   public Beans getBeans();
   
   /**
    * The implementation of {@link Contexts} in use.
    */
   public <T extends Context> Contexts<T> getContexts();
   
   /**
    * The implementation of {@link Managers} in use.
    */
   public Managers getManagers();
   
   /**
    * The implementation of {@link Containers} in use.
    */
   public Containers getContainers();
   
   /**
    * Whether to run integration tests, by default false.
    */
   public boolean isRunIntegrationTests();

   public void setOutputDirectory(String outputDirectory);

   public void setStandalone(boolean standalone);

   public void setConnectTimeout(int connectTimeout);

   public void setLibraryDirectory(String libraryDir);

   public void setInContainerTestLauncher(TestLauncher testLauncher);

   public void setBeans(Beans beans);

   public <T extends Context> void setContexts(Contexts<T> contexts);

   public void setManagers(Managers managers);

   public void setContainers(Containers containers);
   
   /**
    * The implementation of {@link StandaloneContainers} in use.
    */
   public StandaloneContainers getStandaloneContainers();
   
   public void setStandaloneContainers(StandaloneContainers standaloneContainers);

   public void setRunIntegrationTests(boolean runIntegrationTests);
   
   public void setEl(EL el);
   
   /**
    * The implementation of {@link EL} in use.
    */
   public EL getEl();
   
   /**
    * The TCK will use this as the remote host to connect to run in container 
    * tests. By default localhost:8080
    * 
    */
   public String getHost();
   
   public void setHost(String host);
   
}