package org.jboss.jsr299.tck.spi;


/**
 * Provides Bean related operations.
 * 
 * The TCK porting package must provide an implementation of this interface which is 
 * suitable for the target implementation.
 * 
 * This interface may be removed.
 * 
 * @author Shane Bryzak
 * @author Pete Muir
 * @author David Allen
 * 
 */
public interface Beans
{

   public static final String PROPERTY_NAME = Beans.class.getName();
   
   /**
    * Tests whether the given class is declaring an Enterprise Bean.
    * 
    * @param clazz the type of bean being tested
    * 
    * @return true only if class declares an Enterprise Bean
    */
   public boolean isEnterpriseBean(Class<?> clazz);

   /**
    * Tests whether the given class is declaring a stateful session bean.
    * 
    * @param clazz the type being tested
    * @return true only if class declares a stateful session bean
    */
   public boolean isStatefulBean(Class<?> clazz);

   /**
    * Tests whether the given class is declaring a stateless session bean.
    * 
    * @param clazz the type being tested
    * @return true only if class declares a stateless session bean
    */
   public boolean isStatelessBean(Class<?> clazz);

   /**
    * Tests whether the given class is declaring an entity bean.
    * 
    * @param clazz the type being tested
    * @return true only if class declares an entity bean
    */
   public boolean isEntityBean(Class<?> clazz);
   
   public boolean isProxy(Object instance);
   
}
