package org.jboss.jsr299.tck;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

import javax.context.Context;
import javax.inject.manager.Manager;

import org.jboss.jsr299.tck.api.Configuration;
import org.jboss.jsr299.tck.impl.ConfigurationImpl;

public abstract class AbstractTest
{
   
   protected abstract static class RunInDependentContext
   {
   
      protected void setup()
      {
         getCurrentConfiguration().getContexts().setActive(getCurrentConfiguration().getContexts().getDependentContext());
      }
   
      protected void cleanup()
      {
         getCurrentConfiguration().getContexts().setInactive(getCurrentConfiguration().getContexts().getDependentContext());
      }
   
      public final void run() throws Exception
      {
         try
         {
            setup();
            execute();
         }
         finally
         {
            cleanup();
         }
      }
   
      protected abstract void execute() throws Exception;
   
   }
   
   private Manager currentManager;
   
   protected void setCurrentManager(Manager currentManager)
   {
      this.currentManager = currentManager;
   }
   

   protected Manager getCurrentManager()
   {
      return currentManager;
   }

   protected byte[] serialize(Object instance) throws IOException
   {
      ByteArrayOutputStream bytes = new ByteArrayOutputStream();
      ObjectOutputStream out = new ObjectOutputStream(bytes);
      out.writeObject(instance);
      return bytes.toByteArray();
   }

   protected Object deserialize(byte[] bytes) throws IOException, ClassNotFoundException
   {
      ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes));
      return in.readObject();
   }

   protected static void setContextActive(Context context)
   {
      getCurrentConfiguration().getContexts().setActive(context);
   }

   protected static void setContextInactive(Context context)
   {
      getCurrentConfiguration().getContexts().setInactive(context);
   }

   protected static void destroyContext(Context context)
   {
      getCurrentConfiguration().getContexts().destroyContext(context);
   }
   
   protected static Configuration getCurrentConfiguration()
   {
      return ConfigurationImpl.get();
   }
   
   protected static boolean isThrowablePresent(Class<? extends Throwable> throwableType, Throwable throwable)
   {
      if (throwable == null)
      {
         return false;
      }
      else if (throwableType.isAssignableFrom(throwable.getClass()))
      {
         return true;
      }
      else
      {
         return isThrowablePresent(throwableType, throwable.getCause()); 
      }
   }
   
   public String getContextPath()
   {
      return "http://" + getCurrentConfiguration().getHost() + "/" + this.getClass().getName() + "/";
   }
   
}