package org.jboss.jsr299.tck.impl;

import javax.context.Context;

import org.jboss.jsr299.tck.api.Configuration;
import org.jboss.jsr299.tck.api.TestLauncher;
import org.jboss.jsr299.tck.spi.Beans;
import org.jboss.jsr299.tck.spi.Containers;
import org.jboss.jsr299.tck.spi.Contexts;
import org.jboss.jsr299.tck.spi.EL;
import org.jboss.jsr299.tck.spi.Managers;
import org.jboss.jsr299.tck.spi.StandaloneContainers;

public class ConfigurationImpl implements Configuration
{
   
   public static final String INTEGRATION_TEST_PACKAGE_NAME = "org.jboss.jsr299.tck.integration";
   public static final String UNIT_TEST_PACKAGE_NAME = "org.jboss.jsr299.tck.unit";
   
   private static Configuration current;
   public static Configuration get()
   {
      if (ConfigurationImpl.current == null)
      {
         ConfigurationImpl.current = new PropertiesBasedConfigurationImpl().loadSPIImplementation();
      }
      return ConfigurationImpl.current;
   }
   
   private String outputDirectory;
   private boolean standalone;
   private boolean runIntegrationTests;
   private int connectTimeout;
   private String libraryDirectory;
   private TestLauncher testLauncher;
   private Beans beans;
   private Contexts<? extends Context> contexts;
   private Managers managers;
   private Containers containers;
   private StandaloneContainers standaloneContainers;
   private EL el;
   private String host;
   
   protected ConfigurationImpl()
   {
   }
   
   public ConfigurationImpl(Configuration configuration)
   {
      this.outputDirectory = configuration.getOutputDirectory();
      this.standalone = configuration.isStandalone();
      this.runIntegrationTests = configuration.isRunIntegrationTests();
      this.connectTimeout = configuration.getConnectTimeout();
      this.libraryDirectory = configuration.getLibraryDirectory();
      this.testLauncher = configuration.getInContainerTestLauncher();
      this.beans = configuration.getBeans();
      this.contexts = configuration.getContexts();
      this.managers = configuration.getManagers();
      this.containers = configuration.getContainers();
      this.el = configuration.getEl();
      this.standaloneContainers = configuration.getStandaloneContainers();
      this.host = configuration.getHost();
   }

   public String getOutputDirectory()
   {
      return outputDirectory;
   }
   
   public void setOutputDirectory(String outputDirectory)
   {
      this.outputDirectory = outputDirectory;
   }
   
   public boolean isStandalone()
   {
      return standalone;
   }
   
   public void setStandalone(boolean standalone)
   {
      this.standalone = standalone;
   }

   public int getConnectTimeout()
   {
      return connectTimeout;
   }
   
   public void setConnectTimeout(int deploymentDelay)
   {
      this.connectTimeout = deploymentDelay;
   }
   
   public String getLibraryDirectory()
   {
      return libraryDirectory;
   }
   
   public void setLibraryDirectory(String libraryDir)
   {
      this.libraryDirectory = libraryDir;
   }
   
   public TestLauncher getInContainerTestLauncher()
   {
      return testLauncher;
   }
   
   public void setInContainerTestLauncher(TestLauncher testLauncher)
   {
      this.testLauncher = testLauncher;
   }

   public Beans getBeans()
   {
      return beans;
   }

   public void setBeans(Beans beans)
   {
      this.beans = beans;
   }

   @SuppressWarnings("unchecked")
   public <T extends Context> Contexts<T> getContexts()
   {
      return (Contexts<T>) contexts;
   }

   public <T extends Context> void setContexts(Contexts<T> contexts)
   {
      this.contexts = contexts;
   }

   public Managers getManagers()
   {
      return managers;
   }

   public void setManagers(Managers managers)
   {
      this.managers = managers;
   }

   public Containers getContainers()
   {
      return containers;
   }

   public void setContainers(Containers containers)
   {
      this.containers = containers;
   }

   public boolean isRunIntegrationTests()
   {
      return runIntegrationTests;
   }

   public void setRunIntegrationTests(boolean runIntegrationTests)
   {
      this.runIntegrationTests = runIntegrationTests;
   }
   
   @Deprecated
   public EL getEl()
   {
      return el;
   }
   
   @Deprecated
   public void setEl(EL el)
   {
      this.el = el;
   }
   
   public StandaloneContainers getStandaloneContainers()
   {
      return standaloneContainers;
   }
   
   public void setStandaloneContainers(StandaloneContainers standaloneContainers)
   {
      this.standaloneContainers = standaloneContainers;
   }

   public String getHost()
   {
      return host;
   }

   public void setHost(String host)
   {
      this.host = host;
   }

   public TestLauncher getTestLauncher()
   {
      return testLauncher;
   }

   public void setTestLauncher(TestLauncher testLauncher)
   {
      this.testLauncher = testLauncher;
   }   
   
   @Override
   public String toString()
   {
      StringBuilder configuration = new StringBuilder();
      configuration.append("TCK Configuration\n");
      configuration.append("-----------------\n");
      configuration.append("\tBeans: ").append(getBeans()).append("\n");
      configuration.append("\tContainers: ").append(getContainers()).append("\n");
      configuration.append("\tContexts: ").append(getContexts()).append("\n");
      configuration.append("\tConnect Timeout: ").append(getConnectTimeout()).append("\n");
      configuration.append("\tEL: ").append(getEl()).append("\n");
      configuration.append("\tHost: ").append(getHost()).append("\n");
      configuration.append("\tLibrary Directory: ").append(getLibraryDirectory()).append("\n");
      configuration.append("\tManagers: ").append(getManagers()).append("\n");
      configuration.append("\tOutput Directory: ").append(getOutputDirectory()).append("\n");
      configuration.append("\tRun Integration Tests: ").append(isRunIntegrationTests()).append("\n");
      configuration.append("\tStandalone: ").append(isStandalone()).append("\n");
      configuration.append("\tTest Launcher: ").append(getTestLauncher()).append("\n");
      
      return configuration.toString();
   }
   
}
