package org.jboss.jsr299.tck.impl;

import javax.context.Context;

import org.jboss.jsr299.tck.api.Configurable;
import org.jboss.jsr299.tck.api.TestLauncher;
import org.jboss.jsr299.tck.impl.util.DeploymentProperties;
import org.jboss.jsr299.tck.spi.Beans;
import org.jboss.jsr299.tck.spi.Containers;
import org.jboss.jsr299.tck.spi.Contexts;
import org.jboss.jsr299.tck.spi.EL;
import org.jboss.jsr299.tck.spi.Managers;
import org.jboss.jsr299.tck.spi.StandaloneContainers;

public class PropertiesBasedConfigurationImpl extends ConfigurationImpl
{
   
   private final DeploymentProperties deploymentProperties;
   
   public PropertiesBasedConfigurationImpl()
   {
      this.deploymentProperties = new DeploymentProperties();
      
      setOutputDirectory(deploymentProperties.getStringValue(OUTPUT_DIRECTORY_PROPERTY_NAME, DEFAULT_OUTPUT_DIRECTORY, false));
      setStandalone(deploymentProperties.getBooleanValue(STANDALONE_PROPERTY_NAME, DEFAULT_STANDALONE, false));
      setRunIntegrationTests(deploymentProperties.getBooleanValue(RUN_INTEGRATION_TESTS_PROPERTY_NAME, DEFAULT_RUN_INTEGRATION_TESTS, false));
      setConnectTimeout(deploymentProperties.getIntValue(CONNECT_TIMEOUT_PROPERTY_NAME, DEFAULT_CONNECT_DELAY, false));
      setLibraryDirectory(deploymentProperties.getStringValue(LIBRARY_DIRECTORY_PROPERTY_NAME, DEFAULT_LIBRARY_DIRECTORY, false));
      setHost(deploymentProperties.getStringValue(HOST_PROPERTY_NAME, DEFAULT_HOST, false));
   }
   
   public PropertiesBasedConfigurationImpl loadSPIImplementation()
   {
      setInContainerTestLauncher(getInstanceValue(TestLauncher.PROPERTY_NAME, TestLauncher.class, isRunIntegrationTests() || !isStandalone()));
      setManagers(getInstanceValue(Managers.PROPERTY_NAME, Managers.class, true));
      setContainers(getInstanceValue(Containers.PROPERTY_NAME, Containers.class, !isStandalone() || isRunIntegrationTests()));
      setStandaloneContainers(getInstanceValue(StandaloneContainers.PROPERTY_NAME, StandaloneContainers.class, isStandalone()));
      setBeans(getInstanceValue(Beans.PROPERTY_NAME, Beans.class, true));
      setEl(getInstanceValue(EL.PROPERTY_NAME, EL.class, true));
      
      @SuppressWarnings("unchecked")      
      Contexts<? extends Context> instanceValue = getInstanceValue(Contexts.PROPERTY_NAME, Contexts.class, true);
      
      setContexts(instanceValue);
      return this;
   }
   
   private <T> T getInstanceValue(String propertyName, Class<T> expectedType, boolean required)
   {
      T instance = deploymentProperties.getInstanceValue(propertyName, expectedType, required);
      if (instance instanceof Configurable)
      {
         ((Configurable) instance).setConfiguration(this);
      }
      return instance;
   }
   
}
