package org.jboss.jsr299.tck.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

import javax.xml.parsers.ParserConfigurationException;

import org.apache.log4j.Logger;
import org.jboss.jsr299.tck.api.Configuration;
import org.jboss.jsr299.tck.api.TCK;
import org.jboss.jsr299.tck.impl.packaging.ArtifactGenerator;
import org.testng.TestNG;
import org.testng.xml.Parser;
import org.testng.xml.XmlSuite;
import org.xml.sax.SAXException;

public class TCKImpl extends TCK
{
   
   private static Logger log = Logger.getLogger(TCKImpl.class);
   
   protected void runUnitTests()
   {
      TestNG testNG = new TestNG();
      addUnitTests(testNG);
      if (getConfiguration().getOutputDirectory() != null)
      {
         testNG.setOutputDirectory(getConfiguration().getOutputDirectory());
      }
      testNG.run();
   }
   
   private static void addUnitTests(TestNG testNG)
   {
      InputStream is = TCKImpl.class.getResourceAsStream("/tck-unit-tests.xml");
      if (is == null)
      {
         throw new IllegalStateException("Unable to load testng.xml");
      }
      List<XmlSuite> suites = new ArrayList<XmlSuite>();
      try
      {
         suites.addAll(new Parser(is).parse());
         
      }
      catch (ParserConfigurationException e)
      {
         throw new IllegalStateException("Unable to load testng.xml", e);
      }
      catch (SAXException e)
      {
         throw new IllegalStateException("Unable to load testng.xml", e);
      }
      catch (IOException e)
      {
         throw new IllegalStateException("Unable to load testng.xml", e);
      }
      testNG.setXmlSuites(suites);
   }

   @Override
   public void dumpArtifacts()
   {
      Configuration configuration = new PropertiesBasedConfigurationImpl();
      configuration.setStandalone(false);
      new ArtifactGenerator(configuration).dumpArtifacts();
   }

   @Override
   public Configuration getConfiguration()
   {
      return ConfigurationImpl.get();
   }

}
