package org.jboss.jsr299.tck.impl.packaging;

import static java.lang.annotation.ElementType.TYPE;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * Mark this class as requiring an JSR299 artifact to be deployed for the 
 * container. By default all classes in the current package, as well as support
 * classes, will be deployed. The resultant artifact may not support session
 * beans.
 * 
 * This test may be a unit test (in which case, if the suite is run in 
 * standalone mode, the artifact itself won't be deployed, just the contained 
 * classes and /META-INF/beans.xml file).
 * 
 * @see Classes
 * @see IntegrationTest
 * @see Packaging
 * @see Resources
 * 
 * @author Pete Muir
 *
 */
@Documented
@Retention(RUNTIME)
@Target(TYPE)
public @interface Artifact
{
   
   boolean addCurrentPackage() default true;
   
}
