package org.jboss.jsr299.tck.impl.packaging;

import static java.lang.annotation.ElementType.TYPE;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * Mark this test as an integration test, always requiring running in a 
 * container.
 * 
 * @see Artifact
 * @see IntegrationTest
 * 
 * @author Pete Muir
 *
 */
@Retention(RUNTIME)
@Target(TYPE)
public @interface IntegrationTest
{
   
   boolean runLocally() default false;
   
}
