package org.jboss.jsr299.tck.impl.packaging;

import static org.jboss.jsr299.tck.impl.util.Reflections.loadResource;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

import org.jboss.jsr299.tck.impl.util.Files;

public class ResourceDescriptor
{
   
   private final String name;
   private final URL source;

   public ResourceDescriptor(String name, InputStream source) throws IOException
   {
      this.name = name;
      File file = File.createTempFile(ResourceDescriptor.class.getName(), null);
      file.deleteOnExit();
      Files.copy(source, file);
      this.source = file.toURI().toURL(); 
   }
   
   public ResourceDescriptor(String name, URL source)
   {
      this.name = name;
      this.source = source;
   }
   
   public ResourceDescriptor(String name, String source)
   {
      this.name = name;
      if (name == null)
      {
         throw new IllegalArgumentException("Unable to have a null resource");
      }
      this.source = loadResource(source);
      if (this.source == null)
      {
         throw new IllegalArgumentException("Unable to load file for " + source);
      }
   }
   
   public String getName()
   {
      return name;
   }
   
   public URL getSource()
   {
      return source;
   }
   
   @Override
   public boolean equals(Object obj)
   {
      if (obj instanceof ResourceDescriptor)
      {
         ResourceDescriptor that = (ResourceDescriptor) obj;
         return this.getName().equals(that.getName());
      }
      else
      {
         return false;
      }
   }
   
   @Override
   public int hashCode()
   {
      return name.hashCode();
   }
   
   @Override
   public String toString()
   {
      return name + " (" + source.toString() + ")";
   }
   
}
