package org.jboss.jsr299.tck.impl.packaging.ear;
import static org.jboss.jsr299.tck.impl.util.Reflections.loadResource;

import java.net.URL;

import org.jboss.jsr299.tck.impl.packaging.ResourceDescriptor;
import org.jboss.jsr299.tck.impl.packaging.jsr299.JSR299ArtifactDescriptor;

public class EjbJarArtifactDescriptor extends JSR299ArtifactDescriptor
{
   
   public static final String EJB_JAR_XML_DESTINATION = "META-INF/ejb-jar.xml";
   public static final String STANDARD_EJB_JAR_XML_FILE_NAME = "org/jboss/jsr299/tck/impl/packaging/ear/ejb-jar.xml";
   public static final String CUSTOM_EJB_JAR_XML_FILE_NAME = "org/jboss/jsr299/tck/impl/packaging/ear/custom-ejb-jar.xml";
   
   public EjbJarArtifactDescriptor(Class<?> declaringClass, String beansXmlSourceFileName)
   {
      super(declaringClass, beansXmlSourceFileName);
      URL ejbJarXml = loadResource(CUSTOM_EJB_JAR_XML_FILE_NAME);
      if (ejbJarXml == null)
      {
         ejbJarXml = loadResource(STANDARD_EJB_JAR_XML_FILE_NAME);
      }
      getResources().add(new ResourceDescriptor(EJB_JAR_XML_DESTINATION, ejbJarXml));
   }
   
   @Override
   public String toString()
   {
      return "ejb jar, " + super.toString();
   }
   
   @Override
   public boolean isLibrariesSupported()
   {
      return false;
   }
   
}
