package org.jboss.jsr299.tck.impl.packaging.jsr299;

import static java.lang.annotation.ElementType.TYPE;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import org.jboss.jsr299.tck.impl.packaging.Resource;

/**
 * Override the default (empty) META-INF/beans.xml
 * 
 * @see Resource
 * 
 * @author Pete Muir
 *
 */
@Documented
@Retention(RUNTIME)
@Target(TYPE)
public @interface BeansXml
{
   
   /**
    * Location of the overriding file, relative to the current location or the
    * root this classpath
    * 
    */
   String value();
   
}
