package org.jboss.jsr299.tck.impl.packaging.jsr299;

import static org.jboss.jsr299.tck.impl.util.Strings.isEmpty;

import org.jboss.jsr299.tck.impl.packaging.ArtifactDescriptor;
import org.jboss.jsr299.tck.impl.packaging.ResourceDescriptor;

public class JSR299ArtifactDescriptor extends ArtifactDescriptor
{
   
   public static final String BEANS_XML_DESTINATION = "META-INF/beans.xml";
   public static final String STANDARD_BEANS_XML_FILE_NAME = "org/jboss/jsr299/tck/impl/packaging/jsr299/default/beans.xml";
   
   private final ResourceDescriptor beansXml;
   
   public JSR299ArtifactDescriptor(Class<?> declaringClass, String beansXmlSourceFileName)
   {
      super(declaringClass);
      if (!isAddBeansXml())
      {
         this.beansXml = null;
      }
      else
      {
         if (isEmpty(beansXmlSourceFileName))
         {
            beansXmlSourceFileName = STANDARD_BEANS_XML_FILE_NAME;
         }
         this.beansXml = new ResourceDescriptor(getBeansDestination(), beansXmlSourceFileName);
         getResources().add(beansXml);
      }
   }
   
   public String getBeansDestination()
   {
      return BEANS_XML_DESTINATION; 
   }
   
   public ResourceDescriptor getBeansXml()
   {
      return beansXml;
   }
   
   protected boolean isAddBeansXml()
   {
      return true;
   }
   
}
