package org.jboss.jsr299.tck.impl.packaging.jsr299;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;

import org.apache.log4j.Logger;
import org.jboss.jsr299.tck.AbstractDeclarativeTest;
import org.jboss.jsr299.tck.impl.packaging.ArtifactDescriptor;
import org.jboss.jsr299.tck.impl.packaging.ResourceDescriptor;
import org.jboss.jsr299.tck.impl.util.DeploymentProperties;

public class TCKArtifactDescriptor extends JSR299ArtifactDescriptor
{
   
   private static ResourceDescriptor getTckSupportJar()
   {
         ArtifactDescriptor descriptor = new ArtifactDescriptor(TCKArtifactDescriptor.class);
         descriptor.addPackage(AbstractDeclarativeTest.class.getPackage());
         descriptor.addPackage("org.jboss.jsr299.tck.impl", true);
         descriptor.addPackage("org.jboss.jsr299.tck.literals", true);
         descriptor.addPackage("org.jboss.jsr299.tck.runner", true);
         if (descriptor.getClasses().size() == 0)
         {
            throw new AssertionError("Error building tck-support.jar");
         }
         try
         {
            return new ResourceDescriptor("tck-support.jar", descriptor.getJar());
         }
         catch (IOException e)
         {
            throw new RuntimeException("Error building TCK support Jar", e);
         }
   }
   
   private static final Logger log = Logger.getLogger(TCKArtifactDescriptor.class);
   
   private boolean unit;
   private boolean runLocally;
   private Class<? extends Throwable> expectedDeploymentException;
   
   public TCKArtifactDescriptor(Class<?> declaringClass, String beansXmlSourceFileName)
   {
      super(declaringClass, beansXmlSourceFileName);
      if (isLibrariesSupported())
      {
         getLibraries().add(new ResourceDescriptor("testng.jar", "/lib/testng-jdk15.jar"));
         getLibraries().add(new ResourceDescriptor("jsr-299-tck-api.jar", "/lib/jsr299-tck-api.jar"));
         getLibraries().add(getTckSupportJar());
         InputStream deploymentProperties = null;
         try
         {
            deploymentProperties = getDeploymentProperties(declaringClass);
            getResources().add(new ResourceDescriptor(getClassesRoot() + DeploymentProperties.RESOURCE_BUNDLE, deploymentProperties));
         }
         catch (IOException e)
         {
            log.warn("Error generating deployment properties", e);
         }
         finally
         {
            if (deploymentProperties != null)
            {
               try
               {
                  deploymentProperties.close();
               }
               catch (IOException e)
               {
                  log.error("Error generating deployment properties", e);
               }
            }
         }
      }
   }
   
   private static InputStream getDeploymentProperties(Class<?> declaringClass) throws IOException
   {
      ByteArrayOutputStream os = new ByteArrayOutputStream();
      try
      {
         Writer writer = new PrintWriter(os);
         writer.write("className=" + declaringClass.getName());
         writer.flush();
         return new ByteArrayInputStream(os.toByteArray());
      }
      finally
      {
         os.close();
      }
   }
   
   public boolean isUnit()
   {
      return unit;
   }
   
   public void setUnit(boolean unit)
   {
      this.unit = unit;
   }
   
   public Class<? extends Throwable> getExpectedDeploymentException()
   {
      return expectedDeploymentException;
   }
   
   public void setExpectedDeploymentException(Class<? extends Throwable> expectedDeploymentException)
   {
      this.expectedDeploymentException = expectedDeploymentException;
   }
   
   public boolean isRunLocally()
   {
      return runLocally;
   }
   
   public void setRunLocally(boolean runLocally)
   {
      this.runLocally = runLocally;
   }
   
}
