package org.jboss.jsr299.tck.impl.packaging.war;
import static org.jboss.jsr299.tck.impl.util.Reflections.loadResource;

import java.net.URL;

import org.jboss.jsr299.tck.impl.packaging.ResourceDescriptor;
import org.jboss.jsr299.tck.impl.packaging.jsr299.TCKArtifactDescriptor;

public class WarArtifactDescriptor extends TCKArtifactDescriptor
{
   
   public static final String WEB_XML_DESTINATION = "WEB-INF/web.xml";
   public static final String STANDARD_WEB_XML_FILE_NAME = "org/jboss/jsr299/tck/impl/packaging/war/web.xml";
   public static final String CUSTOM_WEB_XML_FILE_NAME = "org/jboss/jsr299/tck/impl/packaging/war/custom-web.xml";
   
   public WarArtifactDescriptor(Class<?> declaringClass, String beansXmlSourceFileName)
   {
      super(declaringClass, beansXmlSourceFileName);
      URL webXml = loadResource(CUSTOM_WEB_XML_FILE_NAME);
      if (webXml == null)
      {
         webXml = loadResource(STANDARD_WEB_XML_FILE_NAME);
      }
      getResources().add(new ResourceDescriptor(WEB_XML_DESTINATION, webXml));
   }
   
   @Override
   public String getClassesRoot()
   {
      return "WEB-INF/classes/";
   }
   
   @Override
   public String toString()
   {
      return "war, " + super.toString();
   }
   
   @Override
   public String getExtension()
   {
      return ".war";
   }
   
   @Override
   public boolean isLibrariesSupported()
   {
      return true;
   }
   
   @Override
   protected String getLibrariesRoot()
   {
      return "WEB-INF/lib";
   }
   
   @Override
   public String getBeansDestination()
   {
      return "WEB-INF/beans.xml";
   }
}
