package org.jboss.jsr299.tck.impl.runner;

import java.util.ArrayList;
import java.util.List;

import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestResult;

public class BufferedListener implements ITestListener
{
   
   private ITestContext context;
   
   
   public BufferedListener()
   {
   }
   
   public void onFinish(ITestContext context)
   {
      this.context = context;
   }
   
   public void onStart(ITestContext context)
   {
      // No-op
   }
   
   public void onTestFailedButWithinSuccessPercentage(ITestResult result)
   {
      // No-op
   }
   
   public void onTestFailure(ITestResult result)
   {
      // No-op
   }
   
   public void onTestSkipped(ITestResult result)
   {
      // No-op
   }
   
   public void onTestStart(ITestResult result)
   {
      // No-op
   }
   
   public void onTestSuccess(ITestResult result)
   {
      // No-op
   }
   
   public ITestContext getContext()
   {
      return context;
   }
   
   public List<ITestResult> getTestResults()
   {
      List<ITestResult> results = new ArrayList<ITestResult>();
      results.addAll(context.getFailedTests().getAllResults());
      results.addAll(context.getPassedTests().getAllResults());
      results.addAll(context.getSkippedTests().getAllResults());
      return results;
   }
   
   public List<ITestResult> getConfigurationResults()
   {
      List<ITestResult> results = new ArrayList<ITestResult>();
      results.addAll(context.getFailedConfigurations().getAllResults());
      results.addAll(context.getPassedConfigurations().getAllResults());
      results.addAll(context.getSkippedConfigurations().getAllResults());
      return results;
   }
   
}
