package org.jboss.jsr299.tck.impl.runner;

import java.io.Serializable;

import org.jboss.jsr299.tck.api.TestResult;
import org.testng.ITestResult;

public class TestResultImpl implements Serializable, TestResult
{
   
   private static final long serialVersionUID = -6608901483105666644L;
   
   private Throwable throwable;
   private Status status;
   
   
   
   public TestResultImpl(Status status, Throwable throwable)
   {
      super();
      this.throwable = throwable;
      this.status = status;
   }

   public Status getStatus()
   {
      return status;
   }
   
   public Throwable getThrowable()
   {
      return throwable;
   }
   
   public static TestResult of(ITestResult testNGResult)
   {
      if (testNGResult.getStatus() == 1)
      {
         return new TestResultImpl(Status.PASSED, null);
      }
      else if (testNGResult.getStatus() == 2)
      {
         return new TestResultImpl(Status.FAILED, testNGResult.getThrowable());
      }
      else if (testNGResult.getStatus() == 3)
      {
         return new TestResultImpl(Status.SKIPPED, testNGResult.getThrowable());
      }
      else
      {
         return null;
      }
   }
   
}
