package org.jboss.jsr299.tck.impl.runner;

import java.util.ArrayList;
import java.util.List;

import org.jboss.jsr299.tck.AbstractDeclarativeTest;
import org.jboss.jsr299.tck.impl.testng.RemoveExpectedExceptionsAnnotationTransformer;
import org.jboss.jsr299.tck.impl.util.DeploymentProperties;
import org.testng.ITestContext;
import org.testng.ITestResult;
import org.testng.TestNG;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

public class TestRunner
{
   
   private List<String> classNames;
   private List<String> methodNames;
   private ITestContext context;
   private List<ITestResult> testResults;
   private List<ITestResult> configurationResults;
   
   public TestRunner()
   {   
      methodNames = new ArrayList<String>();
      classNames = new ArrayList<String>();
      
   }
   
   public List<String> getClassNames()
   {
      return classNames;
   }
   
   public List<String> getMethodNames()
   {
      return methodNames;
   }
   
   public void run(boolean ignoreExpectedExceptions)
   {
      AbstractDeclarativeTest.setInContainer(true);
      if (classNames.size() == 0)
      {
         DeploymentProperties deploymentProperties = new DeploymentProperties();
         this.classNames = deploymentProperties.getPropertyValues("className");
      }
      TestNG testNG = new TestNG(false);
      testNG.setVerbose(0);
      BufferedListener listener = new BufferedListener();
      testNG.addListener(listener);
      List<XmlSuite> xmlSuites = new ArrayList<XmlSuite>();
      testNG.setXmlSuites(xmlSuites);
      xmlSuites.add(createSuite());
      if (ignoreExpectedExceptions)
      {
         testNG.setAnnotationTransformer(new RemoveExpectedExceptionsAnnotationTransformer());
      }
      testNG.run();
      this.context = listener.getContext();
      this.testResults = listener.getTestResults();
      this.configurationResults = listener.getConfigurationResults();
   }
    
   
   private XmlSuite createSuite()
   {
      XmlSuite suite = new XmlSuite();
      suite.setName("JSR-299 TCK");
      suite.setAnnotations("JDK5_ANNOTATION_TYPE");
      for (String className : classNames)
      {
         XmlTest test = new XmlTest(suite);
         test.setName("JSR-299 TCK" + className);
         List<XmlClass> testClasses = new ArrayList<XmlClass>();
         XmlClass testClass = new XmlClass(className);
         for (String methodName : getMethodNames())
         {
            testClass.getIncludedMethods().add(methodName);
         }
         testClasses.add(testClass);
         test.setXmlClasses(testClasses);
      }
      return suite;
   }
   
   public ITestContext getContext()
   {
      return context;
   }
   
   public List<ITestResult> getTestResults()
   {
      return testResults;
   }
   
   public List<ITestResult> getConfigurationResults()
   {
      return configurationResults;
   }
   
}
