package org.jboss.jsr299.tck.impl.runner.servlet;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;

import org.jboss.jsr299.tck.api.Configurable;
import org.jboss.jsr299.tck.api.Configuration;
import org.jboss.jsr299.tck.api.TestLauncher;
import org.jboss.jsr299.tck.api.TestResult;
import org.jboss.jsr299.tck.impl.runner.TestResultImpl;

public class ServletTestLauncher implements TestLauncher, Configurable
{

   private Configuration configuration;
   
   public void setConfiguration(Configuration configuration)
   {
      this.configuration = configuration;
   }
   
   public TestResultImpl launchTest(Method method) throws IOException
   {
      Class<?> testClass = method.getDeclaringClass();
      String url = "http://" + configuration.getHost() + "/" + testClass.getName() + "/?outputMode=serializedObject&methodName=" + method.getName();
      long timeoutTime = System.currentTimeMillis() + configuration.getConnectTimeout();
      boolean interrupted = false;
      while (timeoutTime > System.currentTimeMillis())
      {
         URLConnection connection = new URL(url).openConnection();
         if (!(connection instanceof HttpURLConnection))
         {
            throw new IllegalStateException("Not an http connection! " + connection);
         }
         HttpURLConnection httpConnection = (HttpURLConnection) connection;
         httpConnection.setUseCaches(false);
         httpConnection.setDefaultUseCaches(false);
         try
         {
            httpConnection.connect();
            if (httpConnection.getResponseCode() == HttpURLConnection.HTTP_OK)
            {
               ObjectInputStream ois = new ObjectInputStream(httpConnection.getInputStream());
               Object o;
               try
               {
                  o = ois.readObject();
               }
               catch (ClassNotFoundException e)
               {
                  throw new IOException(e);
               }
               ois.close();
               if (!(o instanceof TestResult))
               {
                  throw new IllegalStateException("Error reading test results - expected a TestResult but got " + o);
               }
               TestResultImpl result = (TestResultImpl) o;
               
               return result;
            }
            else if (httpConnection.getResponseCode() != HttpURLConnection.HTTP_NOT_FOUND)
            {
               throw new IllegalStateException("Error launching test " + testClass.getName() + " at " + url + ". Got " + httpConnection.getResponseCode() + " ("+ httpConnection.getResponseMessage() + ")");
            }
            try
            {
               Thread.sleep(200);
            }
            catch (InterruptedException e)
            {
               interrupted = true;
            }
         }
         finally
         {
            httpConnection.disconnect();
         }
      }
      if (interrupted)
      {
         Thread.currentThread().interrupt();
      }
      throw new IllegalStateException("Error launching test " + testClass.getName() + " at " + url + ". Kept on getting 404s.");
   }
   
}
