package org.jboss.jsr299.tck.impl.testng;

import java.util.Arrays;
import java.util.List;

import org.jboss.jsr299.tck.impl.ConfigurationImpl;
import org.jboss.jsr299.tck.impl.packaging.IntegrationTest;
import org.testng.IMethodSelector;
import org.testng.IMethodSelectorContext;
import org.testng.ITestNGMethod;

public class ExcludeIncontainerUnderInvestigationMethodSelector implements IMethodSelector
{
   
   private static final long serialVersionUID = 7261618804033064979L;

   public boolean includeMethod(IMethodSelectorContext methodContext, ITestNGMethod method, boolean isTestMethod)
   {
      if (!ConfigurationImpl.get().isStandalone() || method.getMethod().getDeclaringClass().isAnnotationPresent(IntegrationTest.class))
      {
         List<String> groups = Arrays.asList(method.getGroups());
         if (groups.contains("incontainer-ri-broken") || groups.contains("incontainer-broken"))
         {
            methodContext.setStopped(true);
            return false;
         }
      }
      return true;
   }
   
   public void setTestMethods(List<ITestNGMethod> arg0)
   {
      
   }
   
}
