package org.jboss.jsr299.tck.impl.util;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;

import org.jboss.jsr299.tck.impl.packaging.ArtifactDescriptor;

/**
 * Utility class for static reflection-type operations
 * 
 * @author Pete Muir
 * 
 */
public class Reflections
{
   /**
    * Checks if all annotations are in a given set of annotations
    * 
    * @param annotations The annotation set
    * @param annotationTypes The annotations to match
    * @return True if match, false otherwise
    */
   public static boolean annotationSetMatches(Set<Annotation> annotations, Class<? extends Annotation>... annotationTypes)
   {
      List<Class<? extends Annotation>> annotationTypeList = new ArrayList<Class<? extends Annotation>>();
      annotationTypeList.addAll(Arrays.asList(annotationTypes));
      for (Annotation annotation : annotations)
      {
         if (annotationTypeList.contains(annotation.annotationType()))
         {
            annotationTypeList.remove(annotation.annotationType());
         }
         else
         {
            return false;
         }
      }
      return annotationTypeList.size() == 0;
   }
   
   public static InputStream loadResourceAsStream(String name)
   {
      InputStream is = null;
      if (Thread.currentThread().getContextClassLoader() != null)
      {
         is = Thread.currentThread().getContextClassLoader().getResourceAsStream(name);
      }
      if (is == null)
      {
         is = ArtifactDescriptor.class.getResourceAsStream(name);
      }
      return is;
   }
   
   public static URL loadResource(String name)
   {
      URL url = null;
      if (Thread.currentThread().getContextClassLoader() != null)
      {
         url = Thread.currentThread().getContextClassLoader().getResource(name);
      }
      if (url == null)
      {
         url = ArtifactDescriptor.class.getResource(name);
      }
      return url;
   }
   
   public static Class<?> loadClass(String name)
   {
      Class<?> clazz = null;
      if (Thread.currentThread().getContextClassLoader() != null)
      {
         try
         {
            clazz = Thread.currentThread().getContextClassLoader().loadClass(name);
         }
         catch (ClassNotFoundException e)
         {
            // no-op
         }
      }
      if (clazz == null)
      {
         try
         {
            clazz = Class.forName(name);
         }
         catch (ClassNotFoundException e)
         {
            // No-op
         }
      }
      return clazz;
   }
   
   public static Iterable<URL> loadResources(String name) throws IOException
   {
      Enumeration<URL> urls = null;
      if (Thread.currentThread().getContextClassLoader() != null)
      {
         urls = Thread.currentThread().getContextClassLoader().getResources(name);
      }
      if (urls == null)
      {
         urls = ArtifactDescriptor.class.getClassLoader().getResources(name);
      }
      return new EnumerationIterable<URL>(urls);
   }

}
