package org.jboss.jsr299.tck.tests.context.conversation.client;

import java.io.IOException;
import java.io.ObjectOutputStream;

import javax.context.Conversation;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.jboss.jsr299.tck.impl.ConfigurationImpl;

public class ConversationStatusServlet extends HttpServlet
{
   
   @Override
   protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException
   {
      String method = req.getParameter("method");
      if ("cid".equals(method))
      {
         serializeToResponse(ConfigurationImpl.get().getManagers().getManager().getInstanceByType(Conversation.class).getId(), resp);
      }
      else if ("cloudDestroyed".equals(method))
      {
         if (Cloud.isDestroyed())
         {
            resp.setStatus(HttpServletResponse.SC_OK);
         }
         else
         {
            resp.sendError(HttpServletResponse.SC_INTERNAL_SERVER_ERROR);
         }
      }
      else if ("invalidateSession".equals(method))
      {
         req.getSession().invalidate();
      }
      else if ("resetCloud".equals(method))
      {
         Cloud.setDestroyed(false);
      }
      else
      {
         resp.sendError(HttpServletResponse.SC_INTERNAL_SERVER_ERROR);
      }
   }
   
   private void serializeToResponse(Object object, HttpServletResponse resp) throws IOException
   {
      ObjectOutputStream oos = new ObjectOutputStream(resp.getOutputStream());
      oos.writeObject(object);
      oos.flush();
      oos.close();
   }
   
}
