package org.jboss.jsr299.tck.tests.context.conversation.client;

import javax.context.ContextNotActiveException;
import javax.context.Conversation;
import javax.context.ConversationScoped;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.servlet.http.HttpServletResponse;

import org.jboss.jsr299.tck.impl.ConfigurationImpl;

public class ConversationTestPhaseListener implements PhaseListener
{
   
   public static final String ACTIVE_BEFORE_APPLY_REQUEST_VALUES_HEADER_NAME = "org.jboss.jsr299.tck.activeBeforeApplyRequestValues";

   private boolean activeBeforeApplyRequestValues;
   
   public void afterPhase(PhaseEvent event)
   {
   }

   public void beforePhase(PhaseEvent event)
   {
      if (event.getPhaseId().equals(PhaseId.APPLY_REQUEST_VALUES))
      {
         try
         {
            ConfigurationImpl.get().getManagers().getManager().getContext(ConversationScoped.class);
            activeBeforeApplyRequestValues = true;
         }
         catch (ContextNotActiveException e)
         {
            activeBeforeApplyRequestValues = false;
         }
      }
      if (event.getPhaseId().equals(PhaseId.RENDER_RESPONSE))
      {
         HttpServletResponse response = (HttpServletResponse) event.getFacesContext().getExternalContext().getResponse();
         response.addHeader(AbstractConversationTest.CID_HEADER_NAME, ConfigurationImpl.get().getManagers().getManager().getInstanceByType(Conversation.class).getId());
         response.addHeader(Cloud.RAINED_HEADER_NAME, new Boolean(ConfigurationImpl.get().getManagers().getManager().getInstanceByType(Cloud.class).isRained()).toString());
         response.addHeader(ACTIVE_BEFORE_APPLY_REQUEST_VALUES_HEADER_NAME, new Boolean(activeBeforeApplyRequestValues).toString());
      }
   }

   public PhaseId getPhaseId()
   {
      return PhaseId.ANY_PHASE;
   }
   
}
