package org.jboss.jsr299.tck.tests.context.conversation.client;

import org.apache.commons.httpclient.HttpClient;
import org.hibernate.tck.annotations.SpecAssertion;
import org.jboss.jsr299.tck.impl.packaging.Artifact;
import org.jboss.jsr299.tck.impl.packaging.Classes;
import org.jboss.jsr299.tck.impl.packaging.IntegrationTest;
import org.jboss.jsr299.tck.impl.packaging.Resource;
import org.jboss.jsr299.tck.impl.packaging.Resources;
import org.jboss.jsr299.tck.impl.packaging.war.WarArtifactDescriptor;
import org.testng.annotations.Test;

/**
 * 
 * @author Nicklas Karlsson
 * 
 * Spec version: PRD2
 */
@Artifact(addCurrentPackage=false)
@Classes({Storm.class, ConversationTestPhaseListener.class, ConversationStatusServlet.class, Cloud.class, CloudController.class})
@IntegrationTest(runLocally=true)
@Resources({
  @Resource(destination=WarArtifactDescriptor.WEB_XML_DESTINATION, source="web.xml"),
  @Resource(destination="WEB-INF/faces-config.xml", source="faces-config.xml"),
  @Resource(destination="clouds.jspx", source="clouds.jsf"),
  @Resource(destination="cloud.jspx", source="cloud.jsf")
})
public class InvalidatingSessionDestroysConversationTest extends AbstractConversationTest
{
   
   @Test(groups = { "contexts" })
   @SpecAssertion(section = "8.5.4", id = "q")
   public void testInvalidatingSessionDestroysConversation() throws Exception
   {
      HttpClient client = new HttpClient();
      resetCloud(client);
      request(client, "/clouds.jsf");
      assert !isCloudDestroyed(client);
      invalidateSession(client);
      assert isCloudDestroyed(client);
   }

}