/*
 * JBoss, Home of Professional Open Source
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,  
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jboss.jsr299.tck.tests.context.dependent.ejb;

import javax.context.CreationalContext;
import javax.context.RequestScoped;
import javax.inject.manager.Bean;

import org.hibernate.tck.annotations.SpecAssertion;
import org.jboss.jsr299.tck.AbstractDeclarativeTest;
import org.jboss.jsr299.tck.impl.packaging.Artifact;
import org.jboss.jsr299.tck.impl.packaging.IntegrationTest;
import org.jboss.jsr299.tck.impl.packaging.Packaging;
import org.jboss.jsr299.tck.impl.packaging.PackagingType;
import org.testng.annotations.Test;

/**
 * Spec version: Public Release Draft 2
 */
@IntegrationTest
@Packaging(PackagingType.EAR)
@Artifact
public class DependentContextEjbTest extends AbstractDeclarativeTest
{
   @Test(groups = { "contexts", "injection", "ejb3", "integration" })
   @SpecAssertion(section = "8.3", id = "k")
   public void testContextIsActiveDuringEJBDependencyInjection()
   {
      Bean<FoxRunLocal> foxRunBean = getCurrentManager().resolveByType(FoxRunLocal.class).iterator().next();
      FoxRunLocal foxRun = foxRunBean.create(new CreationalContext<FoxRunLocal>(){

         public void push(FoxRunLocal incompleteInstance) {}
         
      });
      assert foxRun.getFox() != null;
   }

   @Test(groups = { "contexts", "postconstruct", "ejb3", "integration" })
   @SpecAssertion(section = "8.3", id = "l")
   public void testContextIsActiveDuringEJBPostConstruct()
   {
      Fox.setDependentContextActiveDuringPostConstruct(false);
      getCurrentManager().getInstanceByType(FoxLocal.class).getName();
      assert Fox.isDependentContextActiveDuringPostConstruct();
   }

   @Test(groups = { "contexts", "ejb3", "integration", "ri-broken" })
   @SpecAssertion(section = "8.3.2", id = "ba")
   public void testDestroyingEjbDestroysDependents() throws Exception
   {
      new RunInDependentContext()
      {

         @Override
         protected void execute() throws Exception
         {
            assert getCurrentManager().resolveByType(HouseLocal.class).size() == 1;
            Bean<HouseLocal> bean = getCurrentManager().resolveByType(HouseLocal.class).iterator().next();
            HouseLocal instance = getCurrentManager().getContext(RequestScoped.class).get(bean, new CreationalContext<HouseLocal>(){

               public void push(HouseLocal incompleteInstance) {}
               
            });
            Room.destroyed = false;
            Table.destroyed = false;
            bean.destroy(instance);
            assert Room.destroyed;
            assert Table.destroyed;
         }

      }.run();
   }
   
   @Test(groups = { "contexts", "ejb3", "integration","ri-broken" })
   @SpecAssertion(section = "8.3.2", id = "ba")
   public void testDestroyingEjbDestroysDependentSimples() throws Exception
   {
      new RunInDependentContext()
      {

         @Override
         protected void execute() throws Exception
         {
            assert getCurrentManager().resolveByType(FarmLocal.class).size() == 1;
            Bean<FarmLocal> farmBean = getCurrentManager().resolveByType(FarmLocal.class).iterator().next();
            FarmLocal farm = getCurrentManager().getContext(RequestScoped.class).get(farmBean, new CreationalContext<FarmLocal>(){

               public void push(FarmLocal incompleteInstance) {}
               
            });
            Horse.destroyed = false;
            Stable.destroyed = false;
            farmBean.destroy(farm);
            assert Horse.destroyed;
            assert Stable.destroyed;
         }

      }.run();
   }

}
