package org.jboss.jsr299.tck.tests.context.passivating;

import java.io.IOException;

import javax.inject.IllegalProductException;

import org.hibernate.tck.annotations.SpecAssertion;
import org.jboss.jsr299.tck.AbstractDeclarativeTest;
import org.jboss.jsr299.tck.impl.packaging.Artifact;
import org.jboss.jsr299.tck.impl.packaging.IntegrationTest;
import org.jboss.jsr299.tck.impl.packaging.Packaging;
import org.jboss.jsr299.tck.impl.packaging.PackagingType;
import org.testng.annotations.Test;

@Artifact
@IntegrationTest
@Packaging(PackagingType.EAR)
public class PassivatingContextIntegrationTest extends AbstractDeclarativeTest
{
   
   @Test(groups = { "stub", "contexts", "passivation", "jms" })
   @SpecAssertion(section = "8.4", id = "u")
   public void testJMSEndpointProxyIsSerializable()
   {
      assert false;
   }

   @Test(groups = { "contexts", "passivation", "integration", "broken" }, expectedExceptions = IllegalProductException.class)
   @SpecAssertion(section = "8.4", id = "p")
   public void testDependentScopedProducerMethodReturnsNonSerializableObjectForInjectionIntoStatefulSessionBeanFails() throws SecurityException, NoSuchMethodException
   {
      getCurrentManager().getInstanceByType(MaarianHaminaLocal_Broken.class);
   }

   /**
    * the Web Bean is an EJB stateful session bean, and it is passivated by the
    * EJB container.
    */
   // TODO requires an EJB instance
   @Test(groups = { "contexts", "passivation", "stub", "integration" })
   @SpecAssertion(section = "8.4", id = "g")
   public void testStatefulEJBIsSerializedWhenPassivatedByEJBContainer() throws IOException, ClassNotFoundException
   {
      assert false;
   }

   @Test(groups = { "contexts", "passivation", "stub", "integration" }, expectedExceptions = IllegalProductException.class)
   @SpecAssertion(section = "8.4", id = "p")
   public void testDependentScopedProducerFieldReturnsNonSerializableObjectForInjectionIntoStatefulSessionBeanFails() throws Exception
   {
      assert false;
   }
   
}
