package org.jboss.jsr299.tck.tests.context.request;

import org.hibernate.tck.annotations.SpecAssertion;
import org.jboss.jsr299.tck.AbstractDeclarativeTest;
import org.jboss.jsr299.tck.impl.packaging.Artifact;
import org.jboss.jsr299.tck.impl.packaging.IntegrationTest;
import org.testng.annotations.Test;

/**
 * 
 * Spec version: PRD2
 */
@Artifact
@IntegrationTest
public class RequestContextTest extends AbstractDeclarativeTest
{

   /**
    * The request scope is active during the service() method of any Servlet in
    * the web application.
    */
   @Test(groups = { "stub", "contexts", "servlet", "integration" })
   @SpecAssertion(section = "8.5.1", id = "a")
   public void testRequestScopeActiveDuringServiceMethod()
   {
      assert false;
   }

   /**
    * The request context is destroyed at the end of the servlet request, after
    * the Servlet service() method returns.
    */
   @Test(groups = { "stub", "contexts", "servlet", "integration" })
   @SpecAssertion(section = "8.5.1", id = "c")
   public void testRequestScopeIsDestroyedAfterServiceMethod()
   {
      assert false;
   }

   /**
    * The request scope is active during any Java EE web service invocation.
    */
   @Test(groups = { "stub", "contexts", "webservice", "integration" })
   @SpecAssertion(section = "8.5.1", id = "d")
   public void testRequestScopeActiveDuringWebSericeInvocation()
   {
      assert false;
   }

   /**
    * The request context is destroyed after the web service invocation
    * completes
    */
   @Test(groups = { "stub", "contexts", "webservice", "integration" })
   @SpecAssertion(section = "8.5.1", id = "e")
   public void testRequestScopeIsDestroyedAfterWebServiceInvocation()
   {
      assert false;
   }

   /**
    * The request scope is active during any remote method invocation of any EJB
    * bean, during any call to an EJB timeout method and during message delivery
    * to any EJB message driven bean.
    */
   @Test(groups = { "stub", "contexts", "ejb3", "integration" })
   @SpecAssertion(section = "8.5.1", id = "h")
   public void testRequestScopeActiveDuringRemoteMethodInvocationOfEjb()
   {
      assert false;
   }

   /**
    * The request scope is active during any remote method invocation of any EJB
    * bean, during any call to an EJB timeout method and during message delivery
    * to any EJB message driven bean.
    */
   @Test(groups = { "stub", "contexts", "ejb3", "integration" })
   @SpecAssertion(section = "8.5.1", id = "i")
   public void testRequestScopeActiveDuringCallToEjbTimeoutMethod()
   {
      assert false;
   }

   /**
    * The request scope is active during any remote method invocation of any EJB
    * bean, during any call to an EJB timeout method and during message delivery
    * to any EJB message driven bean.
    */
   @Test(groups = { "stub", "contexts", "ejb3", "integration" })
   @SpecAssertion(section = "8.5.1", id = "j")
   public void testRequestScopeActiveDuringEjbMessageDelivery()
   {
      assert false;
   }

   /**
    * The request context is destroyed after the remote method invocation,
    * timeout or message delivery completes.
    */
   @Test(groups = { "stub", "contexts", "ejb3", "integration" })
   @SpecAssertion(section = "8.5.1", id = "k")
   public void testRequestScopeDestroyedAfterRemoteMethodInvocationOfEjb()
   {
      assert false;
   }

   /**
    * The request context is destroyed after the remote method invocation,
    * timeout or message delivery completes.
    */
   @Test(groups = { "stub", "contexts", "ejb3", "integration" })
   @SpecAssertion(section = "8.5.1", id = "l")
   public void testRequestScopeDestroyedAfterCallToEjbTimeoutMethod()
   {
      assert false;
   }

   /**
    * The request context is destroyed after the remote method invocation,
    * timeout or message delivery completes.
    */
   @Test(groups = { "stub", "contexts", "ejb3", "integration" })
   @SpecAssertion(section = "8.5.1", id = "m")
   public void testRequestScopeDestroyedAfterEjbMessageDelivery()
   {
      assert false;
   }

}
