package org.jboss.jsr299.tck.tests.definition.bean;

import java.lang.annotation.Annotation;

import javax.context.RequestScoped;
import javax.inject.AnnotationLiteral;
import javax.inject.Production;
import javax.inject.manager.Bean;

import org.hibernate.tck.annotations.SpecAssertion;
import org.hibernate.tck.annotations.SpecAssertions;
import org.jboss.jsr299.tck.AbstractDeclarativeTest;
import org.jboss.jsr299.tck.impl.packaging.Artifact;
import org.testng.annotations.Test;

/**
 * This test class should be used for common assertions about Web Beans
 * 
 * @author Pete Muir
 * 
 * Spec version: PRD2
 */
@Artifact
public class BeanDefinitionTest extends AbstractDeclarativeTest
{
   
   private static Annotation TAME_LITERAL = new AnnotationLiteral<Tame>() {};
   
   // TODO This should actually somehow test the reverse as well - that the container
   // throws a definition exception if any of these occur
   
   @Test
   @SpecAssertion(section = "2", id = "a")
   public void testBeanTypesNonEmpty()
   {
      assert getCurrentManager().resolveByType(RedSnapper.class).size() == 1;
      assert getCurrentManager().resolveByType(RedSnapper.class).iterator().next().getTypes().size() > 0;
   }
   
   @Test
   @SpecAssertion(section = "2", id = "b")
   public void testBindingTypesNonEmpty()
   {
      assert getCurrentManager().resolveByType(RedSnapper.class).size() == 1;
      assert getCurrentManager().resolveByType(RedSnapper.class).iterator().next().getBindings().size() > 0;
   }
   
   @Test
   @SpecAssertions({
      @SpecAssertion(section = "2", id = "c"),
      @SpecAssertion(section = "2.4", id = "a"),
      @SpecAssertion(section = "3.2.3", id = "ba")
   })
   public void testHasScopeType()
   {
      assert getCurrentManager().resolveByType(RedSnapper.class).size() == 1;
      assert getCurrentManager().resolveByType(RedSnapper.class).iterator().next().getScopeType().equals(RequestScoped.class);
   }
   
   @Test
   @SpecAssertions({
      @SpecAssertion(section = "2", id = "d"),
      @SpecAssertion(section = "2.5.3", id = "a"),
      @SpecAssertion(section = "3.2.3", id = "bc")
   })
   public void testHasDeploymentType()
   {
      assert getCurrentManager().resolveByType(RedSnapper.class).size() == 1;
      assert getCurrentManager().resolveByType(RedSnapper.class).iterator().next().getDeploymentType().equals(Production.class);
   }
   
   @Test(groups = "producerMethod")
   @SpecAssertion(section = "5.2", id = "b")
   public void testIsNullable() throws Exception
   {
      assert getCurrentManager().resolveByType(int.class).size() == 1;
      Bean<Integer> bean = getCurrentManager().resolveByType(int.class).iterator().next();
      assert !bean.isNullable();
      assert getCurrentManager().resolveByType(Animal.class, TAME_LITERAL).size() == 1;
      Bean<Animal> animalBean = getCurrentManager().resolveByType(Animal.class, TAME_LITERAL).iterator().next();
      assert animalBean.isNullable();
   }
   
   @Test
   @SpecAssertions({
     @SpecAssertion(section = "3.2.2", id = "a"),
     @SpecAssertion(section = "2.2", id = "a"),
     @SpecAssertion(section = "2.2", id = "d"),
     @SpecAssertion(section = "2.2", id = "e"),
     @SpecAssertion(section = "2.2", id = "k"),
     @SpecAssertion(section = "2.2", id = "l")
   })
   public void testBeanTypes()
   {
      assert getCurrentManager().resolveByType(Tarantula.class).size() == 1;
      Bean<Tarantula> bean = getCurrentManager().resolveByType(Tarantula.class).iterator().next();
      assert bean.getTypes().size() == 6;
      assert bean.getTypes().contains(Tarantula.class);
      assert bean.getTypes().contains(Spider.class);
      assert bean.getTypes().contains(Animal.class);
      assert bean.getTypes().contains(Object.class);
      assert bean.getTypes().contains(DeadlySpider.class);
      assert bean.getTypes().contains(DeadlyAnimal.class);
   }
   
   @Test
   @SpecAssertion(section = "2.2", id = "g")
   public void testFinalApiType()
   {
      getCurrentManager().resolveByType(DependentFinalTuna.class);
   }
   
}