package org.jboss.jsr299.tck.tests.definition.deployment;

import javax.inject.DeploymentException;
import javax.inject.Production;
import javax.inject.UnsatisfiedDependencyException;
import javax.inject.manager.Bean;

import org.hibernate.tck.annotations.SpecAssertion;
import org.hibernate.tck.annotations.SpecAssertions;
import org.jboss.jsr299.tck.AbstractDeclarativeTest;
import org.jboss.jsr299.tck.impl.packaging.Artifact;
import org.jboss.jsr299.tck.impl.packaging.jsr299.BeansXml;
import org.testng.annotations.Test;

/**
 * 
 * Spec version: Public Release Draft 2
 * 
 */
@Artifact
@BeansXml("beans.xml")
public class DeploymentTypeDefinitionTest extends AbstractDeclarativeTest
{

   /**
    * 
    * TODO This text is not really a testable assertion
    */
   @Test(groups = { "stub", "annotationDefinition", "deploymentType" })
   @SpecAssertion(section = "2.5.2", id = "a")
   public void testDeploymentTypeHasCorrectTarget()
   {
      assert false;
   }

   /**
    * 
    * TODO This text is not really a testable assertion
    */
   @Test(groups = { "stub", "annotationDefinition", "deploymentType" })
   @SpecAssertion(section = "2.5.2", id = "c")
   public void testDeploymentTypeDeclaresDeploymentTypeAnnotation()
   {
      assert false;
   }

   @Test(groups = { "deploymentType" })
   @SpecAssertion(section = "2.5.3", id = "c")
   public void testDeploymentTypeInhertitedFromDeclaringBean() throws Exception
   {
      assert getCurrentManager().resolveByType(BlackWidow.class).size() == 1;
      Bean<BlackWidow> blackWidowSpiderModel = getCurrentManager().resolveByType(BlackWidow.class).iterator().next();
      assert blackWidowSpiderModel.getDeploymentType().equals(AnotherDeploymentType.class);
   }

   /**
    * 
    * TODO Section 2.5.4 does not claim that XML overrides Java for deployment
    * types
    */
   @Test(groups = { "stub", "webbeansxml", "deploymentType" })
   @SpecAssertion(section = "2.5.4", id = "a")
   public void testXmlDeploymentTypeElement()
   {
      assert false;
   }

   @Test(groups = { "webbeansxml", "deploymentType" })
   @SpecAssertion(section = "2.5.5", id = "a")
   public void testDefaultDeploymentType()
   {
      assert getCurrentManager().resolveByType(Tarantula.class).size() == 1;
      Bean<Tarantula> bean = getCurrentManager().resolveByType(Tarantula.class).iterator().next();
      assert bean.getDeploymentType().equals(Production.class);
   }

   @Test(groups = { "deploymentType" })
   @SpecAssertion(section = "2.5.5", id = "b")
   public void testHighestPrecedenceDeploymentTypeFromStereotype()
   {
      assert getCurrentManager().resolveByType(Rhinoceros.class).size() == 1;
      Bean<?> bean = getCurrentManager().resolveByType(Rhinoceros.class).iterator().next();
      assert bean.getDeploymentType().equals(HornedAnimalDeploymentType.class);
   }

   @Test(groups = { "beanLifecycle", "deploymentType" }, expectedExceptions = UnsatisfiedDependencyException.class)
   @SpecAssertion(section = "2.5.6", id = "a")
   public void testBeanWithDisabledDeploymentTypeNotInstantiated()
   {
      getCurrentManager().getInstanceByType(RedSnapper.class);
   }

   @Test(groups = { "stub", "webbeansxml", "deploymentType" }, expectedExceptions = DeploymentException.class)
   @SpecAssertion(section = "2.5.4", id = "b")
   public void testMultipleDeployElementsCannotBeDefined()
   {
      assert false;
   }

   @Test(groups = { "deploymentType" })
   @SpecAssertions( { 
      @SpecAssertion(section = "2.5.5", id = "c"), 
      @SpecAssertion(section = "2.7.2", id = "da")
   })
   public void testWebBeanDeploymentTypeOverridesStereotype()
   {
      assert getCurrentManager().resolveByType(Reindeer.class).size() == 1;
      Bean<Reindeer> bean = getCurrentManager().resolveByType(Reindeer.class).iterator().next();
      assert bean.getDeploymentType().equals(Production.class);
   }

   @Test(groups = { "deploymentType" })
   @SpecAssertion(section = "4.1", id = "ca")
   public void testDeploymentTypeDeclaredInheritedIsInherited() throws Exception
   {
      assert getCurrentManager().resolveByType(BorderCollie.class).size() == 1;
      assert getCurrentManager().resolveByType(BorderCollie.class).iterator().next().getDeploymentType().equals(AnotherDeploymentType.class);
   }

   @Test(groups = { "deploymentType" })
   @SpecAssertion(section = "4.1", id = "ca")
   public void testDeploymentTypeNotDeclaredInheritedIsNotInherited()
   {
      assert getCurrentManager().resolveByType(ShetlandPony.class).size() == 1;
      assert getCurrentManager().resolveByType(ShetlandPony.class).iterator().next().getDeploymentType().equals(Production.class);
   }

   @Test(groups = { "deploymentType" })
   @SpecAssertion(section = "4.1", id = "ca")
   public void testDeploymentTypeDeclaredInheritedIsBlockedByIntermediateDeploymentTypeNotMarkedInherited()
   {
      assert getCurrentManager().resolveByType(GoldenRetriever.class).size() == 1;
      assert getCurrentManager().resolveByType(GoldenRetriever.class).iterator().next().getDeploymentType().equals(Production.class);
   }

   @Test(groups = { "deploymentType" })
   @SpecAssertion(section = "4.1", id = "ca")
   public void testDeploymentTypeDeclaredInheritedIsBlockedByIntermediateDeploymentTypeMarkedInherited()
   {
      assert getCurrentManager().resolveByType(GoldenLabrador.class).size() == 1;
      assert getCurrentManager().resolveByType(GoldenLabrador.class).iterator().next().getDeploymentType().equals(InheritedDeploymentType.class);
   }

}
