package org.jboss.jsr299.tck.tests.definition.deployment.custom;

import javax.inject.Standard;

import org.hibernate.tck.annotations.SpecAssertion;
import org.hibernate.tck.annotations.SpecAssertions;
import org.jboss.jsr299.tck.AbstractDeclarativeTest;
import org.jboss.jsr299.tck.impl.packaging.Artifact;
import org.jboss.jsr299.tck.impl.packaging.jsr299.BeansXml;
import org.testng.annotations.Test;

/**
 * 
 * Spec version: PRD2
 *
 */
@Artifact
@BeansXml("beans.xml")
public class CustomDeploymentTypeTest extends AbstractDeclarativeTest
{
   
   @SuppressWarnings("unchecked")
   @Test 
   @SpecAssertions({
      @SpecAssertion(section = "2.5.6", id = "b"),
      @SpecAssertion(section = "2.5.2", id = "d")
   })
   public void testCustomDeploymentTypes()
   {
      assert getCurrentConfiguration().getManagers().getEnabledDeploymentTypes().size() == 3;
      assert getCurrentConfiguration().getManagers().getEnabledDeploymentTypes().get(0).equals(Standard.class);
      assert getCurrentConfiguration().getManagers().getEnabledDeploymentTypes().get(1).equals(AnotherDeploymentType.class);
      assert getCurrentConfiguration().getManagers().getEnabledDeploymentTypes().get(2).equals(HornedAnimalDeploymentType.class);
   }
   
}
