package org.jboss.jsr299.tck.tests.definition.name;

import javax.inject.DefinitionException;
import javax.inject.manager.Bean;

import org.hibernate.tck.annotations.SpecAssertion;
import org.hibernate.tck.annotations.SpecAssertions;
import org.jboss.jsr299.tck.AbstractDeclarativeTest;
import org.jboss.jsr299.tck.impl.packaging.Artifact;
import org.testng.annotations.Test;

/**
 * 
 * Spec version: PRD2
 *
 */
@Artifact
public class NameDefinitionTest extends AbstractDeclarativeTest
{
   
   @Test(groups="stub", expectedExceptions=DefinitionException.class) 
   @SpecAssertion(section="2.6", id = "a")
   public void testInvalidElIdentifierUsedAsWebBeanName()
   {
      assert false;
   }
   
   @Test 
   @SpecAssertions({
      @SpecAssertion(section="2.6.1", id = "a"),
      @SpecAssertion(section="2", id="e"),
      @SpecAssertion(section = "3.2.3", id = "bb")
   })
   public void testNonDefaultNamed()
   {
      assert getCurrentManager().resolveByType(Moose.class).size() == 1;
      Bean<Moose> moose =getCurrentManager().resolveByType(Moose.class).iterator().next(); 
      assert moose.getName().equals("aMoose");
   }
   
   @Test(groups={"stub", "webbeansxml"}) 
   @SpecAssertion(section="2.6.2", id = "a")
   public void testNonDefaultXmlNamed()
   {
      assert false;
   }
   
   @Test(groups={"stub", "webbeansxml"}) 
   @SpecAssertions({
      @SpecAssertion(section="2.6.2", id = "b"),
      @SpecAssertion(section = "2.6.3",id = "b")
   })
   public void testJavaNamedUsedWhenNoXmlSpecified()
   {
      assert false;
   }
   
   @Test 
   @SpecAssertions({
      @SpecAssertion(section= "2.6.3", id = "a"),
      @SpecAssertion(section = "3.2.8", id = "a"),
      @SpecAssertion(section = "2.6.1", id = "d")
   })
   public void testDefaultNamed()
   {
      assert getCurrentManager().resolveByType(Haddock.class).size() == 1; 
      Bean<Haddock> haddock = getCurrentManager().resolveByType(Haddock.class).iterator().next();
      assert haddock.getName() != null;
      assert haddock.getName().equals("haddock");
   }
   
   @Test(groups={"stub", "webbeansxml"}) 
   @SpecAssertion(section="2.6.3", id = "b")
   public void testDefaultXmlNamed()
   {
      assert false;
   }
   
   @Test 
   @SpecAssertions({
      @SpecAssertion(section = "2.6.3", id = "c"), 
      @SpecAssertion(section = "2.7", id = "a"),
      @SpecAssertion(section = "2.7.1.3", id = "b")
   })
   public void testSterotypeDefaultsName()
   {
      assert getCurrentManager().resolveByType(RedSnapper.class).size() == 1; 
      Bean<RedSnapper> bean = getCurrentManager().resolveByType(RedSnapper.class).iterator().next();
      assert bean.getName().equals("redSnapper");
   }
   
   @Test 
   @SpecAssertions({
      @SpecAssertion(section="2.6.4", id = "a"),
      @SpecAssertion(section="2", id="e")
   })
   public void testNotNamedInJava()
   {
      assert getCurrentManager().resolveByType(SeaBass.class).size() == 1; 
      Bean<SeaBass> bean = getCurrentManager().resolveByType(SeaBass.class).iterator().next();
      assert bean.getName() == null;
   }
   
   @Test(groups="stub") @SpecAssertion(section="2.6.4", id = "a")
   public void testNotNamedInXml()
   {
      assert false;
   }
   
   @Test @SpecAssertion(section="2.6.4", id = "a")
   public void testNotNamedInStereotype()
   {
      assert getCurrentManager().resolveByType(Minnow.class).size() == 1; 
      Bean<Minnow> bean = getCurrentManager().resolveByType(Minnow.class).iterator().next();
      assert bean.getName() == null;
   }
   
}
