package org.jboss.jsr299.tck.tests.definition.scope;

import javax.context.ApplicationScoped;
import javax.context.Dependent;
import javax.context.RequestScoped;
import javax.inject.manager.Bean;

import org.hibernate.tck.annotations.SpecAssertion;
import org.hibernate.tck.annotations.SpecAssertions;
import org.jboss.jsr299.tck.AbstractDeclarativeTest;
import org.jboss.jsr299.tck.impl.packaging.Artifact;
import org.testng.annotations.Test;

/**
 * 
 * Spec version: PRD2
 *
 */
@Artifact
public class ScopeDefinitionTest extends AbstractDeclarativeTest
{
   
   @Test @SpecAssertion(section="2.4", id = "c")
   public void testScopeTypesAreExtensible()
   {
      assert getCurrentManager().resolveByType(Mullet.class).size() == 1; 
      Bean<Mullet> bean = getCurrentManager().resolveByType(Mullet.class).iterator().next();
      assert bean.getScopeType().equals(AnotherScopeType.class);
   }
   
   @Test(groups={"stub", "annotationDefinition"}) 
   @SpecAssertion(section="2.4.2", id = "aa")
   public void testScopeTypeHasCorrectTarget()
   {
      assert false;
   }

   @Test(groups={"stub", "annotationDefinition"}) 
   @SpecAssertion(section="2.4.2", id = "b")
   public void testScopeTypeDeclaresScopeTypeAnnotation()
   {
      assert false;
   }
   
   @Test @SpecAssertion(section="2.4.3", id = "a")
   public void testScopeDeclaredInJava()
   {
      assert getCurrentManager().resolveByType(SeaBass.class).size() == 1; 
      Bean<SeaBass> bean = getCurrentManager().resolveByType(SeaBass.class).iterator().next();
      assert bean.getScopeType().equals(RequestScoped.class);
   }
   
   @Test(groups={"stub", "webbeansxml"}) 
   @SpecAssertion(section="2.4.4", id = "a")
   public void testScopeDeclaredInXml()
   {
      assert false;
   }
   
   @Test @SpecAssertion(section="2.4.5", id = "a")
   public void testDefaultScope()
   {
      assert getCurrentManager().resolveByType(Order.class).size() == 1; 
      Bean<Order> bean = getCurrentManager().resolveByType(Order.class).iterator().next();
      assert bean.getScopeType().equals(Dependent.class);
   }
   
   @Test
   @SpecAssertions({
     @SpecAssertion(section = "2.4.5", id = "e"),
     @SpecAssertion(section = "2.7.2", id = "a")
   })
   public void testScopeSpecifiedAndStereotyped()
   {
      assert getCurrentManager().resolveByType(Minnow.class).size() == 1; 
      Bean<Minnow> bean = getCurrentManager().resolveByType(Minnow.class).iterator().next();
      assert bean.getScopeType().equals(RequestScoped.class);
   }
   
   @Test @SpecAssertion(section="2.4.5", id = "d")
   public void testMutipleIncompatibleScopeStereotypesWithScopeSpecified()
   {
      assert getCurrentManager().resolveByType(Pollock.class).size() == 1; 
      Bean<Pollock> bean = getCurrentManager().resolveByType(Pollock.class).iterator().next();
      assert bean.getScopeType().equals(Dependent.class);
   }
   
   @Test @SpecAssertion(section="2.4.5", id = "c")
   public void testMutipleCompatibleScopeStereotypes()
   {
      assert getCurrentManager().resolveByType(Grayling.class).size() == 1; 
      Bean<Grayling> bean = getCurrentManager().resolveByType(Grayling.class).iterator().next();
      assert bean.getScopeType().equals(ApplicationScoped.class);
   }
   
   @Test
   @SpecAssertions({
     @SpecAssertion(section = "2.7.2", id = "db"),
     @SpecAssertion(section = "4.1", id = "ab")
   })
   public void testWebBeanScopeTypeOverridesStereotype()
   {
      assert getCurrentManager().resolveByType(RedSnapper.class).size() == 1; 
      Bean<RedSnapper> bean = getCurrentManager().resolveByType(RedSnapper.class).iterator().next();
      assert bean.getScopeType().equals(RequestScoped.class);
   }
   
   @Test @SpecAssertion(section="4.1", id = "ba")
   public void testScopeTypeDeclaredInheritedIsInherited() throws Exception
   {
      assert getCurrentManager().resolveByType(BorderCollie.class).size() == 1; 
      assert getCurrentManager().resolveByType(BorderCollie.class).iterator().next().getScopeType().equals(RequestScoped.class);
   }
   
   @Test @SpecAssertion(section="4.1", id = "ba")
   public void testScopeTypeNotDeclaredInheritedIsNotInherited()
   {
      assert getCurrentManager().resolveByType(ShetlandPony.class).size() == 1; 
      assert getCurrentManager().resolveByType(ShetlandPony.class).iterator().next().getScopeType().equals(Dependent.class);
   }
   
   @Test @SpecAssertion(section="4.1", id = "ba")
   public void testScopeTypeDeclaredInheritedIsBlockedByIntermediateScopeTypeMarkedInherited()
   {
      assert getCurrentManager().resolveByType(GoldenRetriever.class).size() == 1; 
   }
   
   @Test @SpecAssertion(section="4.1", id = "ba")
   public void testScopeTypeDeclaredInheritedIsBlockedByIntermediateScopeTypeNotMarkedInherited()
   {
      assert getCurrentManager().resolveByType(GoldenLabrador.class).size() == 1; 
      assert getCurrentManager().resolveByType(GoldenLabrador.class).iterator().next().getScopeType().equals(Dependent.class);
   }
   
}