package org.jboss.jsr299.tck.tests.event.firesall;

import org.hibernate.tck.annotations.SpecAssertion;
import org.jboss.jsr299.tck.AbstractDeclarativeTest;
import org.jboss.jsr299.tck.impl.packaging.Artifact;
import org.testng.annotations.Test;

@Artifact
public class AllEventTypesTest extends AbstractDeclarativeTest
{
   /**
    * The event types of the event include all superclasses and interfaces of
    * the class of the event object.
    * 
    * @throws Exception
    */
   @Test(groups = { "events" })
   @SpecAssertion(section = "7.1", id = "c")
   public void testEventTypeIncludesAllSuperclassesAndInterfacesOfEventObject() throws Exception
   {
      // Fire a single complex type of event with many observers
      new RunInDependentContext()
      {

         @Override
         protected void execute() throws Exception
         {
            AllEventTypesObserver theObserver = getCurrentManager().getInstanceByType(AllEventTypesObserver.class);
            getCurrentManager().fireEvent(new ComplexEvent());
            assert theObserver.getTotalEventsObserved() == 4;
         }

      }.run();
   }
}
