/*
 * JBoss, Home of Professional Open Source
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,  
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jboss.jsr299.tck.tests.event.register.fires1;

import java.util.Set;

import javax.event.Observer;

import org.hibernate.tck.annotations.SpecAssertion;
import org.jboss.jsr299.tck.AbstractDeclarativeTest;
import org.jboss.jsr299.tck.impl.packaging.Artifact;
import org.jboss.jsr299.tck.impl.packaging.jsr299.BeansXml;
import org.testng.annotations.Test;

/**
 * Tests proper functioning of the implicit event bean injected
 * when @Fires is used on an Event<T> type.
 * 
 * @author David Allen
 *
 */
@Artifact
@BeansXml("beans.xml")
public class ImplicitEventBeanTest extends AbstractDeclarativeTest
{
   @Test(groups = { "events", "broken" })
   @SpecAssertion(section = "7.6", id = "i")
   public void testFiresAnnotationOnEventTypes() throws Exception
   {
      new RunInDependentContext()
      {

         @Override
         protected void execute() throws Exception
         {
            BlueFacedParrotFinch bean = getCurrentManager().getInstanceByType(BlueFacedParrotFinch.class);
            bean.methodThatRegistersObserver();

            Set<Observer<String>> observers = getCurrentManager().resolveObservers("String type event");
            assert observers.size() == 1;
         }
         
      }.run();
      new RunInDependentContext()
      {

         @Override
         protected void execute() throws Exception
         {
            StarFinch starFinch = getCurrentManager().getInstanceByType(StarFinch.class);
            FinchKeeper birdKeeper = getCurrentManager().getInstanceByType(FinchKeeper.class);
            BirdCage birdCage = getCurrentManager().getInstanceByType(BirdCage.class);
            assert starFinch != null;
            assert birdCage != null;
            assert birdCage.getSomeMess() != null;
            assert birdKeeper.isNewMessDetected();
         }
         
      }.run();
      new RunInDependentContext()
      {

         @Override
         protected void execute() throws Exception
         {
            OrangeCheekedWaxbill bird = getCurrentManager().getInstanceByType(OrangeCheekedWaxbill.class);
            FinchKeeper birdKeeper = getCurrentManager().getInstanceByType(FinchKeeper.class);
            assert bird != null;
            assert bird.getSomeMess() != null;
            assert birdKeeper.isNewMessDetected();
         }
         
      }.run();
      new RunInDependentContext()
      {

         @Override
         protected void execute() throws Exception
         {
            AuroraFinch bird = getCurrentManager().getInstanceByType(AuroraFinch.class);
            FinchKeeper birdKeeper = getCurrentManager().getInstanceByType(FinchKeeper.class);
            assert bird != null;
            assert birdKeeper.isNewMessDetected();
         }
         
      }.run();
   }
}
