package org.jboss.jsr299.tck.tests.event.register.observer1;

import javax.event.Observer;
import javax.inject.DuplicateBindingTypeException;

import org.hibernate.tck.annotations.SpecAssertion;
import org.jboss.jsr299.tck.AbstractDeclarativeTest;
import org.jboss.jsr299.tck.impl.packaging.Artifact;
import org.testng.annotations.Test;

@Artifact
public class DuplicateBindingsToRemoveObserverTest extends AbstractDeclarativeTest
{
   public static class AnEventType
   {
   }

   public static class AnObserver implements Observer<AnEventType>
   {
      public boolean wasNotified = false;

      public void notify(AnEventType event)
      {
         wasNotified = true;
      }
   }

   @Test(groups = { "events" }, expectedExceptions = { DuplicateBindingTypeException.class })
   @SpecAssertion(section = "7.3", id = "k")
   public void testMultipleInstancesOfSameBindingTypeWhenRemovingObserverFails()
   {
      Observer<AnEventType> observer = new AnObserver();
      getCurrentManager().removeObserver(observer, AnEventType.class, new RoleBinding("Admin"), new TameAnnotationLiteral(), new TameAnnotationLiteral());
   }
}
