/*
 * JBoss, Home of Professional Open Source
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,  
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jboss.jsr299.tck.tests.event.register.observer1;

import java.lang.annotation.Annotation;
import java.util.Set;

import javax.event.Observer;
import javax.inject.TypeLiteral;

import org.hibernate.tck.annotations.SpecAssertion;
import org.hibernate.tck.annotations.SpecAssertions;
import org.jboss.jsr299.tck.AbstractDeclarativeTest;
import org.jboss.jsr299.tck.impl.packaging.Artifact;
import org.testng.annotations.Test;

/**
 * Tests for the manager.addObserver() method.
 * 
 * @author David Allen
 * 
 */
@Artifact
public class ManagerAddObserverTest extends AbstractDeclarativeTest
{
   public static class AnEventType
   {
   }

   public static class AnObserver implements Observer<AnEventType>
   {
      public boolean wasNotified = false;

      public void notify(AnEventType event)
      {
         wasNotified = true;
      }
   }

   @Test(groups = { "events" })
   @SpecAssertions( { @SpecAssertion(section = "7.3", id = "b"), @SpecAssertion(section = "7.3", id = "c") })
   public void testManagerAddObserver()
   {
      Observer<AnEventType> observer1 = new AnObserver();

      // First test with the Class<T> of the event type
      getCurrentManager().addObserver(observer1, AnEventType.class);
      Set<Observer<AnEventType>> resolvedObservers = getCurrentManager().resolveObservers(new AnEventType());
      assert resolvedObservers.size() == 1;
      assert resolvedObservers.iterator().next() == observer1;

      // Now test with the TypeLiteral<T> of the event type
      Observer<AnEventType> observer2 = new AnObserver();
      getCurrentManager().addObserver(observer2, new TypeLiteral<AnEventType>()
      {
      });
      resolvedObservers = getCurrentManager().resolveObservers(new AnEventType());
      assert resolvedObservers.size() == 2;
      boolean foundObserver = false;
      for (Observer<AnEventType> obs : resolvedObservers)
      {
         if (obs == observer2)
         {
            foundObserver = true;
            break;
         }
      }
      assert foundObserver;

      // Try adding an observer with some binding types
      Observer<AnEventType> observer3 = new AnObserver();
      Annotation[] bindingTypes = new Annotation[] { new RoleBinding("Admin"), new RoleBinding("Manager") };
      getCurrentManager().addObserver(observer3, AnEventType.class, bindingTypes);
      resolvedObservers = getCurrentManager().resolveObservers(new AnEventType(), bindingTypes);
      assert resolvedObservers.size() == 3;
      foundObserver = false;
      for (Observer<AnEventType> obs : resolvedObservers)
      {
         if (obs == observer3)
         {
            foundObserver = true;
            break;
         }
      }
      assert foundObserver;
   }
}
