/*
 * JBoss, Home of Professional Open Source
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,  
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jboss.jsr299.tck.tests.event.register.observer2;

import java.lang.annotation.Annotation;
import java.util.Set;

import javax.event.Observer;
import javax.inject.TypeLiteral;

import org.hibernate.tck.annotations.SpecAssertion;
import org.jboss.jsr299.tck.AbstractDeclarativeTest;
import org.jboss.jsr299.tck.impl.packaging.Artifact;
import org.testng.annotations.Test;

/**
 * Tests the manager.removeObserver() method.
 *
 * @author David Allen
 *
 */
@Artifact
public class ManagerRemoveObserverTest extends AbstractDeclarativeTest
{
   public static class AnEventType
   {
   }

   public static class AnObserver implements Observer<AnEventType>
   {
      public boolean wasNotified = false;

      public void notify(AnEventType event)
      {
         wasNotified = true;
      }
   }

   @Test(groups = { "events" })
   @SpecAssertion(section = "7.3", id = "e")
   public void testManagerRemoveObserver()
   {
      Observer<AnEventType> observer = new AnObserver();

      // First test with the Class<T> of the event type
      getCurrentManager().addObserver(observer, AnEventType.class);
      getCurrentManager().removeObserver(observer, AnEventType.class);
      Set<Observer<AnEventType>> resolvedObservers = getCurrentManager().resolveObservers(new AnEventType());
      assert resolvedObservers.isEmpty();

      // Now test with the TypeLiteral<T> of the event type
      observer = new AnObserver();
      getCurrentManager().addObserver(observer, new TypeLiteral<AnEventType>()
      {
      });
      getCurrentManager().removeObserver(observer, new TypeLiteral<AnEventType>()
      {
      });
      resolvedObservers = getCurrentManager().resolveObservers(new AnEventType());
      assert resolvedObservers.isEmpty();

      // Also test with binding types
      Annotation[] bindings = new Annotation[] { new RoleBinding("Admin") };
      getCurrentManager().addObserver(observer, AnEventType.class, bindings);
      getCurrentManager().removeObserver(observer, AnEventType.class);
      resolvedObservers = getCurrentManager().resolveObservers(new AnEventType(), bindings);
      assert !resolvedObservers.isEmpty();
      getCurrentManager().removeObserver(observer, AnEventType.class, new RoleBinding("Admin"));
      resolvedObservers = getCurrentManager().resolveObservers(new AnEventType(), bindings);
      assert resolvedObservers.isEmpty();
   }
}
