package org.jboss.jsr299.tck.tests.event.resolve.binding;

import javax.event.Observer;
import javax.inject.DuplicateBindingTypeException;

import org.hibernate.tck.annotations.SpecAssertion;
import org.jboss.jsr299.tck.AbstractDeclarativeTest;
import org.jboss.jsr299.tck.impl.packaging.Artifact;
import org.testng.annotations.Test;

@Artifact
public class DuplicateBindingTypesWhenResolvingTest extends AbstractDeclarativeTest
{
   public static class AnEventType
   {
   }

   public static class AnObserver implements Observer<AnEventType>
   {
      public boolean wasNotified = false;

      public void notify(AnEventType event)
      {
         wasNotified = true;
      }
   }

   @Test(groups = { "events" }, expectedExceptions = { DuplicateBindingTypeException.class })
   @SpecAssertion(section = "7.7", id = "d")
   public void testDuplicateBindingTypesWhenResolvingFails()
   {
      AnObserver observer = new AnObserver();
      getCurrentManager().addObserver(observer, AnEventType.class, new BindingTypeABinding());
      getCurrentManager().resolveObservers(new AnEventType(), new BindingTypeABinding(), new BindingTypeABinding());
   }
}
