package org.jboss.jsr299.tck.tests.event.resolve.binding;

import java.util.Set;

import javax.event.Observer;

import org.hibernate.tck.annotations.SpecAssertion;
import org.jboss.jsr299.tck.AbstractDeclarativeTest;
import org.jboss.jsr299.tck.impl.packaging.Artifact;
import org.testng.annotations.Test;

@Artifact
public class ResolvingChecksBindingTypeMembersTest extends AbstractDeclarativeTest
{
   public static class AnEventType
   {
   }

   public static class AnObserver implements Observer<AnEventType>
   {
      public boolean wasNotified = false;

      public void notify(AnEventType event)
      {
         wasNotified = true;
      }
   }

   @Test(groups = { "events" })
   @SpecAssertion(section = "7.7", id = "g")
   public void testResolvingChecksBindingTypeMembers()
   {
      AnObserver observer = new AnObserver();
      AnObserver anotherObserver = new AnObserver();
      getCurrentManager().addObserver(observer, AnEventType.class, new BindingTypeCBinding("first-observer"));
      getCurrentManager().addObserver(anotherObserver, AnEventType.class, new BindingTypeCBinding("second-observer"));
      Set<Observer<AnEventType>> resolvedObservers = getCurrentManager().resolveObservers(new AnEventType(), new BindingTypeCBinding("first-observer"));
      assert resolvedObservers.size() == 1;
   }
}
