package org.jboss.jsr299.tck.tests.implementation.enterprise.lifecycle;

import org.hibernate.tck.annotations.SpecAssertion;
import org.hibernate.tck.annotations.SpecAssertions;
import org.jboss.jsr299.tck.AbstractDeclarativeTest;
import org.testng.annotations.Test;

/**
 * Sections
 * 
 * 6.5. Lifecycle of stateful session beans 
 * 6.6. Lifecycle of stateless session and singleton beans 
 * 6.11. Lifecycle of EJBs
 * 
 * Mostly overlapping with other tests...
 * 
 * @author Nicklas Karlsson
 * 
 * Spec version: Public Release Draft 2
 * 
 */
public class EnterpriseBeanLifecycleTest extends AbstractDeclarativeTest
{

   /**
    * When the create() method of a Bean object that represents a stateful
    * session bean that is called, the container creates and returns a session
    * bean proxy, as defined in Section 3.3.9, "Session bean proxies".
    */
   @Test(groups = { "enterpriseBeans", "lifecycle", "integration", "stub" })
   @SpecAssertion(section = "3.3.8", id = "a")
   public void testProxyCreated()
   {
      assert false;
   }

   @Test(groups = { "enterpriseBeans", "clientProxy", "lifecycle", "integration", "stub" })
   @SpecAssertions({
      @SpecAssertion(section = "6.5", id = "b"),
      @SpecAssertion(section = "6", id = "e")
   })
   public void testDestroyMethodCalled() throws Exception
   {
      // GoodDoggie.destructorCalled = false;
      // deployBeans(GoodDoggie.class);
      // new RunInDependentContext()
      // {
      //
      // @Override
      // protected void execute() throws Exception
      // {
      // Set<Bean<LocalGoodDoggie>> goodDoggieBeans =
      // manager.resolveByType(LocalGoodDoggie.class);
      // assert goodDoggieBeans.size() == 1;
      // Bean<LocalGoodDoggie> bean = goodDoggieBeans.iterator().next();
      // LocalGoodDoggie doggie = manager.getInstance(bean);
      // bean.destroy(doggie);
      // // TODO Need to verify that the remove method has been called
      // }
      //
      // }.run();
      assert false;
   }

   @Test(groups = { "enterpriseBeans", "lifecycle", "integration", "stub" })
   @SpecAssertion(section = "6.5", id = "c")
   public void testRemovedEjbIgnored()
   {
      assert false;
   }

   @Test(groups = { "enterpriseBeans", "lifecycle", "integration", "stub" })
   @SpecAssertion(section = "6.11", id = "a")
   public void testFieldInjectionsOnNonContextualEjbs()
   {
      assert false;
   }

   @Test(groups = { "enterpriseBeans", "lifecycle", "integration", "stub" })
   @SpecAssertion(section = "6.11", id = "b")
   public void testInitXMLDefinedValuesOnWebWeanEnterpriseBeans()
   {
      assert false;
   }

   @Test(groups = { "enterpriseBeans", "lifecycle", "integration", "stub" })
   @SpecAssertion(section = "6.11", id = "c")
   public void testInitializerMethodsCalledWithCurrentParameterValues()
   {
      assert false;
   }

   @Test(groups = { "enterpriseBeans", "lifecycle", "interceptors", "stub" })
   @SpecAssertion(section = "6.11", id = "d")
   public void testInterceptorStackIsBuilt()
   {
      assert false;
   }

   @Test(groups = { "enterpriseBeans", "lifecycle", "decorators", "stub" })
   @SpecAssertion(section = "6.11", id = "e")
   public void testDecoratorStackIsBuilt()
   {
      assert false;
   }

   @Test(groups = { "enterpriseBeans", "lifecycle", "stub" })
   @SpecAssertion(section = "6.11", id = "f")
   public void testDependentObjectsDestroyed()
   {
      assert false;
   }

}
