package org.jboss.jsr299.tck.tests.implementation.enterprise.newAndOtherBinding;

import javax.inject.DefinitionException;

import org.hibernate.tck.annotations.SpecAssertion;
import org.jboss.jsr299.tck.AbstractDeclarativeTest;
import org.jboss.jsr299.tck.impl.packaging.Artifact;
import org.jboss.jsr299.tck.impl.packaging.ExpectedDeploymentException;
import org.testng.annotations.Test;

@Artifact
@ExpectedDeploymentException(DefinitionException.class)
public class NewAndOtherBindingTest extends AbstractDeclarativeTest
{
   

   /**
    * If the @New binding type appears in conjunction with some other binding
    * type, or is specified for a field or parameter of a type which does not
    * satisfy the definition of a simple Web Bean implementation class or
    * enterprise Web Bean implementation class, a DefinitionException is thrown
    * by the container at deployment time.
    */
   @Test(groups = { "new" })
   @SpecAssertion(section = "review", id = "review")
   public void testNewAnnotationCannotAppearInConjunctionWithOtherBindingType()
   {
      assert false;
   }
   
}
