package org.jboss.jsr299.tck.tests.implementation.initializer;

import org.hibernate.tck.annotations.SpecAssertion;
import org.hibernate.tck.annotations.SpecAssertions;
import org.jboss.jsr299.tck.AbstractDeclarativeTest;
import org.jboss.jsr299.tck.impl.packaging.Artifact;
import org.jboss.jsr299.tck.impl.packaging.IntegrationTest;
import org.jboss.jsr299.tck.impl.packaging.Packaging;
import org.jboss.jsr299.tck.impl.packaging.PackagingType;
import org.testng.annotations.Test;

@Artifact
@Packaging(PackagingType.EAR)
@IntegrationTest
public class EjbInitializerMethodTest extends AbstractDeclarativeTest
{
   
   @Test(groups = { "initializerMethod", "ejb3" })
   @SpecAssertions({
      @SpecAssertion(section = "3.9", id = "e"),
      @SpecAssertion(section = "3.9", id = "c")
   })
   public void testInitializerMethodNotABusinessMethod()
   {
      AndalusianChicken.nonBusinessMethodCalled = false;
      getCurrentManager().getInstanceByType(LocalChicken.class).cluck();
      assert AndalusianChicken.nonBusinessMethodCalled = true;
   }
   
}
