package org.jboss.jsr299.tck.tests.implementation.producer.field.lifecycle;

import javax.inject.IllegalProductException;

import org.hibernate.tck.annotations.SpecAssertion;
import org.hibernate.tck.annotations.SpecAssertions;
import org.jboss.jsr299.tck.AbstractDeclarativeTest;
import org.jboss.jsr299.tck.impl.packaging.Artifact;
import org.jboss.jsr299.tck.impl.packaging.jsr299.BeansXml;
import org.testng.annotations.Test;

/**
 * 
 * Spec version: PRD2
 *
 */
@Artifact
@BeansXml("beans.xml")
public class ProducerFieldLifecycleTest extends AbstractDeclarativeTest
{

   @Test(groups = { "producerField" })
   @SpecAssertions({
      @SpecAssertion(section = "6.8", id = "h"),
      @SpecAssertion(section = "3.5", id = "b")
   })
   public void testProducerStaticFieldBean()
   {
      new RunInDependentContext()
      {

         @Override
         protected void execute() throws Exception
         {
            TarantulaConsumer tarantulaConsumer = getCurrentManager().getInstanceByType(TarantulaConsumer.class);
            assert tarantulaConsumer.getConsumedTarantula().equals(StaticTarantulaProducer.produceTarantula);
         }
      };
   }

   @Test(groups = { "producerField" })
   @SpecAssertions({
     @SpecAssertion(section = "6.8", id = "k"),
     @SpecAssertion(section = "6.8", id = "l"),
     @SpecAssertion(section = "6", id = "c"),
     @SpecAssertion(section = "6.8", id = "a"),
     @SpecAssertion(section = "6.8", id = "g")
   })
   public void testProducerFieldBeanCreate() throws Exception
   {
      new RunInDependentContext()
      {
         @Override
         protected void execute() throws Exception
         {
            BlackWidowConsumer spiderConsumer = getCurrentManager().getInstanceByType(BlackWidowConsumer.class);
            assert spiderConsumer.getInjectedSpider().equals(BlackWidowProducer.blackWidow);
         }
      }.run();
   }

   @Test(groups = { "producerField", "specialization" })
   @SpecAssertions({
      @SpecAssertion(section = "6.8", id = "i"),
      @SpecAssertion(section = "4.3.2", id = "d")
   })
   public void testSpecializedBeanAlwaysUsed() throws Exception
   {
      new RunInDependentContext()
      {
         @Override
         protected void execute() throws Exception
         {
            TarantulaConsumer spiderConsumer = getCurrentManager().getInstanceByType(TarantulaConsumer.class);
            assert spiderConsumer.getConsumedTarantula() != null;
            assert spiderConsumer.getConsumedTarantula() instanceof DefangedTarantula;
         }
      }.run();
   }

   @Test(groups = { "producerField" })
   @SpecAssertions({
      @SpecAssertion(section = "3.5", id = "d"),
      @SpecAssertion(section = "6.8", id = "m")
    })    
   public void testProducerFieldReturnsNullIsDependent() throws Exception
   {
      new RunInDependentContext()
      {
         @Override
         protected void execute() throws Exception
         {
            NullSpiderConsumer consumerBean = getCurrentManager().getInstanceByType(NullSpiderConsumer.class);
            assert consumerBean.getInjectedSpider() == null;
         }
      }.run();
   }

   @Test(groups = { "producerField" }, expectedExceptions = IllegalProductException.class)  
   @SpecAssertions({
     @SpecAssertion(section = "3.5", id = "e"),
     @SpecAssertion(section = "6.8", id = "n")
   })   
   public void testProducerFieldReturnsNullIsNotDependent() throws Exception
   {
      new RunInDependentContext()
      {
         @Override
         protected void execute() throws Exception
         {
            NullSpiderConsumerForBrokenProducer consumer = getCurrentManager().getInstanceByType(NullSpiderConsumerForBrokenProducer.class);
            // The injected spider is proxied since it is in the request scope.
            // So to actually create the bean instance, we need to invoke
            // some method on the proxy.
            if (consumer.getInjectedSpider() == null)
            {
               // No proxy in this impl, and no exception = fail
            }
            else
            {
               // Proxy is assumed, so invoke some method
               consumer.getInjectedSpider().bite();
            }
         }
      }.run();
   }

}
