package org.jboss.jsr299.tck.tests.implementation.producer.method.definition;

import javax.annotation.Named;
import javax.context.RequestScoped;
import javax.inject.Produces;

@AnotherDeploymentType
class SpiderProducer
{
   
   private static Spider[] ALL_SPIDERS = { new Tarantula(), new LadybirdSpider(), new DaddyLongLegs() };
   
   @Produces @Tame public Tarantula produceTameTarantula()
   {
      return new DefangedTarantula();
   }
   
   @Produces public Tarantula produceTarantula()
   {
      return new Tarantula();
   }
   
   @Produces public Spider getNullSpider()
   {
      return null;
   }
   
   @Produces public FunnelWeaver<Spider> getFunnelWeaverSpider()
   {
      return new FunnelWeaver<Spider>();
   }

   @Produces public Animal makeASpider()
   {
      return new WolfSpider();
   }
   
   @Produces public int getWolfSpiderSize()
   {
      return 4;
   }
   
   @Produces public Spider[] getSpiders()
   {
      return ALL_SPIDERS;
   }
   
   @Produces @Named @RequestScoped public DaddyLongLegs produceDaddyLongLegs()
   {
      return new DaddyLongLegs();
   }

   @Produces @Named @SpiderDeploymentType public LadybirdSpider getLadybirdSpider()
   {
      return new LadybirdSpider();
   }

   @Produces @Named("blackWidow") public BlackWidow produceBlackWidow()
   {
      return new BlackWidow();
   }
   
   @Produces @AnimalStereotype public WolfSpider produceWolfSpider()
   {
      return new WolfSpider();
   }
   
   @Produces public Bite getBite()
   {
      return new Bite() {};
   }
   
}
