package org.jboss.jsr299.tck.tests.implementation.producer.method.lifecycle;

import javax.context.CreationalContext;
import javax.inject.AnnotationLiteral;
import javax.inject.CreationException;
import javax.inject.IllegalProductException;
import javax.inject.manager.Bean;

import org.hibernate.tck.annotations.SpecAssertion;
import org.hibernate.tck.annotations.SpecAssertions;
import org.jboss.jsr299.tck.AbstractDeclarativeTest;
import org.jboss.jsr299.tck.impl.packaging.Artifact;
import org.jboss.jsr299.tck.impl.packaging.jsr299.BeansXml;
import org.testng.annotations.Test;

/**
 * 
 * Spec version: PRD2
 * 
 */
@Artifact
@BeansXml("beans.xml")
public class ProducerMethodLifecycleTest extends AbstractDeclarativeTest
{

   @Test(groups = { "producerMethod", "broken" })
   @SpecAssertions({
      @SpecAssertion(section = "3.4", id = "c"),
      @SpecAssertion(section = "3.4", id = "k"),
      @SpecAssertion(section = "3.4.2", id = "a"),
      @SpecAssertion(section = "6", id = "a"),
      @SpecAssertion(section = "6.7", id = "e")
   })
   public void testProducerMethodBeanCreate() throws Exception
   {
      assert getCurrentManager().getInstanceByType(Tarantula.class) != null;
   }

   @Test(groups = { "specialization" })
   @SpecAssertions({
      @SpecAssertion(section = "6.7", id = "g"),
      @SpecAssertion(section = "4.3.2", id = "c")
   })
   public void testSpecializedBeanAlwaysUsed() throws Exception
   {
      new RunInDependentContext()
      {

         @Override
         protected void execute() throws Exception
         {
            Egg egg = getCurrentManager().getInstanceByType(Egg.class);
            assert egg != null;
            assert egg.equals(AndalusianChicken.egg);
         }

      }.run();
   }

   @Test(groups = { "stub", "disposalMethod", "beanLifecycle" })
   @SpecAssertion(section = "6.7", id = "m")
   public void testDisposalMethodCalled()
   {
      // TODO Placeholder
      assert false;
   }

   @Test(groups = { "producerMethod", "broken" })
   @SpecAssertions({
      @SpecAssertion(section = "3.4", id = "e"), 
      @SpecAssertion(section = "6.7", id = "k") 
   })
   public void testProducerMethodReturnsNullIsDependent() throws Exception
   {
      assert getCurrentManager().getInstanceByType(Spider.class, new AnnotationLiteral<Null>() {}) == null;
   }

   @Test(groups = "producerMethod", expectedExceptions = IllegalProductException.class)
   @SpecAssertions({
      @SpecAssertion(section = "3.4", id = "f"),
      @SpecAssertion(section = "6.7", id = "l")
   })
   public void testProducerMethodReturnsNullIsNotDependent() throws Exception
   {
      assert getCurrentManager().resolveByType(Spider.class, new AnnotationLiteral<Request>() {}).size() == 1;
      Bean<Spider> spider = getCurrentManager().resolveByType(Spider.class, new AnnotationLiteral<Request>() {}).iterator().next();
      // Do the create ourselves, otherwise we may get a proxy back...
      spider.create(new CreationalContext<Spider>() {

         public void push(Spider incompleteInstance)
         {
            // TODO Auto-generated method stub
            
         }});
   }

   @Test(expectedExceptions = CreationException.class)
   @SpecAssertion(section="6.2", id="h")
   public void testCreationExceptionWrapsCheckedExceptionThrownFromCreate() throws Exception
   {
      new RunInDependentContext()
      {

         protected void execute() throws Exception
         {
            getCurrentManager().getInstanceByType(Lorry.class);
         }

      }.run();
   }

   @Test(expectedExceptions = FooException.class)
   @SpecAssertion(section="6.2", id="g")
   public void testUncheckedExceptionThrownFromCreateNotWrapped() throws Exception
   {
      new RunInDependentContext()
      {

         protected void execute() throws Exception
         {
            getCurrentManager().getInstanceByType(Ship.class);
         }

      }.run();
   }

}
