package org.jboss.jsr299.tck.tests.implementation.simple.lifecycle;

import java.util.Date;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Current;

class Farm
{
   
   public Date founded;
   public Date closed;
   public int initialStaff;
   
   @Current
   FarmOffice farmOffice;
   
   @PostConstruct
   private void postConstruct() 
   {
      founded = new Date();
      initialStaff = farmOffice.noOfStaff;
   }
   
   @PreDestroy
   private void preDestroy() 
   {
      closed = new Date();
   }
   
}
