package org.jboss.jsr299.tck.tests.implementation.simple.lifecycle;

import java.lang.annotation.Annotation;

import javax.inject.AnnotationLiteral;
import javax.inject.CreationException;
import javax.inject.manager.Bean;

import org.hibernate.tck.annotations.SpecAssertion;
import org.hibernate.tck.annotations.SpecAssertions;
import org.jboss.jsr299.tck.AbstractDeclarativeTest;
import org.jboss.jsr299.tck.impl.packaging.Artifact;
import org.jboss.jsr299.tck.impl.packaging.jsr299.BeansXml;
import org.testng.annotations.Test;

/**
 * 
 * Spec version: PRD2
 * 
 */
@Artifact
@BeansXml("beans.xml")
public class SimpleBeanLifecycleTest extends AbstractDeclarativeTest
{
   private static final Annotation TAME_LITERAL = new AnnotationLiteral<Tame>()
   {
   };

   @Test(groups = "beanConstruction")
   @SpecAssertions({
     @SpecAssertion(section = "3.2.6.3", id = "a"),
     @SpecAssertion(section = "2.3.6", id = "d")
   })
   public void testInjectionOfParametersIntoBeanConstructor()
   {
      assert getCurrentManager().resolveByType(FishPond.class).size() == 1;
      FishPond fishPond = getCurrentManager().getInstanceByType(FishPond.class);
      assert fishPond.goldfish != null;
   }
   
   @Test
   @SpecAssertion(section = "3.2.6.3", id = "a")
   public void testBindingTypeAnnotatedConstructor() throws Exception
   {
      new RunInDependentContext()
      {
         @Override
         protected void execute() throws Exception
         {
            getCurrentManager().getInstanceByType(Duck.class);
            assert Duck.constructedCorrectly;
         }
      }.run();
   }

   @Test(groups = { "specialization" })
   @SpecAssertion(section = "3.2.7", id = "c")
   public void testSpecializedBeanAlwaysUsed() throws Exception
   {
      new RunInDependentContext()
      {

         @Override
         protected void execute() throws Exception
         {
            assert getCurrentManager().getInstanceByType(Lion.class, TAME_LITERAL) instanceof MountainLion;
         }

      }.run();
   }

   @Test(groups = "beanLifecycle")
   @SpecAssertions({
      @SpecAssertion(section = "6.2", id = "a"),
      @SpecAssertion(section="2", id="g"),
      @SpecAssertion(section="2.2", id="f"),
      @SpecAssertion(section="3.2.6", id="a"),
      @SpecAssertion(section = "6", id = "d")
   })
   public void testCreateReturnsInstanceOfBean()
   {
      assert getCurrentManager().resolveByType(RedSnapper.class).size() == 1;
      assert getCurrentManager().getInstanceByType(RedSnapper.class) instanceof RedSnapper;
   }

   @Test(groups = { "stub", "beanLifecycle", "interceptors" })
   @SpecAssertion(section = "6.2", id = "b")
   public void testCreateBindsInterceptorStack()
   {
      assert false;
   }

   @Test(groups = { "stub", "beanLifecycle", "decorators" })
   @SpecAssertion(section = "6.2", id = "c")
   public void testCreateBindsDecoratorStack()
   {
      assert false;
   }

   @Test(groups = { "stub", "beanLifecycle", "commonAnnotations", "integration" })
   @SpecAssertion(section = "6.4", id = "b")
   public void testCreateInjectsEjb()
   {
      assert false;
   }

   @Test(groups = { "stub", "beanLifecycle", "commonAnnotations", "integration" })
   @SpecAssertion(section = "6.4", id = "c")
   public void testCreateInjectsPersistenceContext()
   {
      assert false;
   }

   @Test(groups = { "stub", "beanLifecycle", "commonAnnotations", "integration" })
   @SpecAssertion(section = "6.4", id = "d")
   public void testCreateInjectsResource()
   {
      assert false;
   }

   @Test(groups = "injection")
   @SpecAssertions({
      @SpecAssertion(section = "6.4", id = "e"),
      @SpecAssertion(section = "3.8.1", id = "a")
   })
   public void testCreateInjectsFieldsDeclaredInJava()
   {
      assert getCurrentManager().resolveByType(TunaFarm.class).size() == 1;
      TunaFarm tunaFarm = getCurrentManager().getInstanceByType(TunaFarm.class);
      assert tunaFarm.tuna != null;
   }

   @Test(groups = { "beanLifecycle", "lifecycleCallbacks" })
   @SpecAssertions({
     @SpecAssertion(section = "6.2", id = "f"),
     @SpecAssertion(section = "6.3", id = "b"),
     @SpecAssertion(section = "6.4", id = "j"),
     @SpecAssertion(section = "6.4", id = "k")
   })
   public void testPostConstructPreDestroy() throws Exception
   {
      assert getCurrentManager().resolveByType(Farm.class).size() == 1;
      Bean<Farm> farmBean = getCurrentManager().resolveByType(Farm.class).iterator().next();
      Farm farm = getCurrentManager().getInstanceByType(Farm.class);
      assert farm.founded != null;
      assert farm.initialStaff == 20;
      assert farm.closed == null;
      farmBean.destroy(farm);
      assert farm.closed != null;
   }

   @Test
   @SpecAssertion(section = "4.2", id = "baa")
   public void testSubClassInheritsPostConstructOnSuperclass() throws Exception
   {
      OrderProcessor.postConstructCalled = false;
      assert getCurrentManager().resolveByType(CdOrderProcessor.class).size() == 1;
      new RunInDependentContext()
      {
         @Override
         protected void execute() throws Exception
         {
            getCurrentManager().getInstanceByType(CdOrderProcessor.class).order();
         }
      }.run();
      assert OrderProcessor.postConstructCalled;
   }

   @Test
   @SpecAssertion(section = "4.2", id = "bba")
   public void testSubClassInheritsPreDestroyOnSuperclass() throws Exception
   {
      OrderProcessor.preDestroyCalled = false;
      assert getCurrentManager().resolveByType(CdOrderProcessor.class).size() == 1;
      new RunInDependentContext()
      {
         @Override
         protected void execute() throws Exception
         {  
            Bean<CdOrderProcessor> bean = getCurrentManager().resolveByType(CdOrderProcessor.class).iterator().next();
            CdOrderProcessor instance = getCurrentManager().getInstanceByType(CdOrderProcessor.class);
            bean.destroy(instance);
         }
      }.run();
      assert OrderProcessor.preDestroyCalled;
   }

   @Test
   @SpecAssertion(section = "4.2", id = "baa")
   public void testSubClassDoesNotInheritPostConstructOnSuperclassBlockedByIntermediateClass() throws Exception
   {
      assert getCurrentManager().resolveByType(NovelOrderProcessor.class).size() == 1;
      OrderProcessor.postConstructCalled = false;
      new RunInDependentContext()
      {
         @Override
         protected void execute() throws Exception
         {
            getCurrentManager().getInstanceByType(NovelOrderProcessor.class).order();
         }
      }.run();
      assert !OrderProcessor.postConstructCalled;
   }

   @Test
   @SpecAssertion(section = "4.2", id = "bba")
   public void testSubClassDoesNotInheritPreDestroyConstructOnSuperclassBlockedByIntermediateClass() throws Exception
   {
      OrderProcessor.preDestroyCalled = false;
      assert getCurrentManager().resolveByType(NovelOrderProcessor.class).size() == 1;
      new RunInDependentContext()
      {
         @Override
         protected void execute() throws Exception
         {
            Bean<NovelOrderProcessor> bean = getCurrentManager().resolveByType(NovelOrderProcessor.class).iterator().next();
            NovelOrderProcessor instance = getCurrentManager().getInstanceByType(NovelOrderProcessor.class);
            bean.destroy(instance);
         }
      }.run();
      assert !OrderProcessor.preDestroyCalled;

   }

   @Test(expectedExceptions = CreationException.class)
   @SpecAssertion(section = "6.2", id = "h")
   public void testCreationExceptionWrapsCheckedExceptionThrownFromCreate() throws Exception
   {
      assert getCurrentManager().resolveByType(Lorry_Broken.class).size() == 1;
      new RunInDependentContext()
      {

         protected void execute() throws Exception
         {
            getCurrentManager().getInstanceByType(Lorry_Broken.class);
         }

      }.run();
   }

   @Test(expectedExceptions = FooException.class)
   @SpecAssertion(section = "6.2", id = "g")
   public void testUncheckedExceptionThrownFromCreateNotWrapped() throws Exception
   {
      assert getCurrentManager().resolveByType(Van_Broken.class).size() == 1;
      new RunInDependentContext()
      {

         protected void execute() throws Exception
         {
            getCurrentManager().getInstanceByType(Van_Broken.class);
         }

      }.run();
   }

}
