package org.jboss.jsr299.tck.tests.inheritance.specialization.enterprise;

import java.lang.annotation.Annotation;

import javax.inject.AnnotationLiteral;

import org.hibernate.tck.annotations.SpecAssertion;
import org.hibernate.tck.annotations.SpecAssertions;
import org.jboss.jsr299.tck.AbstractDeclarativeTest;
import org.jboss.jsr299.tck.impl.packaging.Artifact;
import org.jboss.jsr299.tck.impl.packaging.IntegrationTest;
import org.jboss.jsr299.tck.impl.packaging.Packaging;
import org.jboss.jsr299.tck.impl.packaging.PackagingType;
import org.jboss.jsr299.tck.impl.packaging.jsr299.BeansXml;
import org.testng.annotations.Test;

@Artifact
@IntegrationTest
@Packaging(PackagingType.EAR)
@BeansXml("beans.xml")
public class EnterpriseBeanSpecializationIntegrationTest extends AbstractDeclarativeTest
{
   
   private static Annotation LANDOWNER_LITERAL = new AnnotationLiteral<Landowner>() {};
   
   @Test
   @SpecAssertions({
     @SpecAssertion(section = "4.3.1", id = "f"),
     @SpecAssertion(section = "3.3.7", id = "b")
   })
   public void testSpecializedBeanNotInstantiated() throws Exception
   {
      new RunInDependentContext()
      {
         
         @Override
         protected void execute() throws Exception
         {
            FarmerLocal farmer = getCurrentManager().getInstanceByType(FarmerLocal.class, LANDOWNER_LITERAL);
            assert farmer.getClassName().equals(LazyFarmer.class.getName());
         }
         
      }.run();
   }
   
   
   @Test(groups="ri-broken") 
   @SpecAssertion(section="4.3.1", id = "g")
   public void testProducerMethodOnSpecializedBeanCalledOnSpecializingBean() throws Exception
   {
      new RunInDependentContext()
      {
         
         @Override
         protected void execute() throws Exception
         {
            assert getCurrentManager().resolveByType(Waste.class).size() == 1;
            assert getCurrentManager().getInstanceByType(Waste.class).getFrom().equals(Office.class.getName());
         }
         
      }.run();
   }
}
